/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.word;

import java.awt.Font;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.OpenOption;
import org.apache.poi.common.usermodel.PictureType;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.poi.POIException;
import org.dromara.hutool.poi.word.DocUtil;
import org.dromara.hutool.poi.word.PictureTypeUtil;
import org.dromara.hutool.poi.word.TableUtil;

public class Word07Writer
implements Closeable {
    private final XWPFDocument doc;
    protected File targetFile;
    protected boolean isClosed;

    public Word07Writer() {
        this(new XWPFDocument());
    }

    public Word07Writer(File targetFile) {
        this(DocUtil.create(targetFile), targetFile);
    }

    public Word07Writer(XWPFDocument doc) {
        this(doc, null);
    }

    public Word07Writer(XWPFDocument doc, File targetFile) {
        this.doc = doc;
        this.targetFile = targetFile;
    }

    public XWPFDocument getDoc() {
        return this.doc;
    }

    public Word07Writer setTargetFile(File targetFile) {
        this.targetFile = targetFile;
        return this;
    }

    public Word07Writer addText(Font font, String ... texts) {
        return this.addText(null, font, texts);
    }

    public Word07Writer addText(ParagraphAlignment align, Font font, String ... texts) {
        XWPFParagraph p = this.doc.createParagraph();
        if (null != align) {
            p.setAlignment(align);
        }
        if (ArrayUtil.isNotEmpty((Object[])texts)) {
            for (String text : texts) {
                XWPFRun run = p.createRun();
                run.setText(text);
                if (null == font) continue;
                run.setFontFamily(font.getFamily());
                run.setFontSize(font.getSize());
                run.setBold(font.isBold());
                run.setItalic(font.isItalic());
            }
        }
        return this;
    }

    public Word07Writer addTable(Iterable<?> data) {
        TableUtil.createTable(this.doc, data);
        return this;
    }

    public Word07Writer addPicture(File picFile, int width, int height) {
        String fileName = picFile.getName();
        return this.addPicture(FileUtil.getInputStream((File)picFile), PictureTypeUtil.getType(fileName), fileName, width, height);
    }

    public Word07Writer addPicture(InputStream in, PictureType picType, String fileName, int width, int height) {
        return this.addPicture(in, picType, fileName, width, height, ParagraphAlignment.CENTER);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Word07Writer addPicture(InputStream in, PictureType picType, String fileName, int width, int height, ParagraphAlignment align) {
        XWPFParagraph paragraph = this.doc.createParagraph();
        paragraph.setAlignment(align);
        XWPFRun run = paragraph.createRun();
        try {
            run.addPicture(in, picType, fileName, Units.toEMU((double)width), Units.toEMU((double)height));
        }
        catch (InvalidFormatException e) {
            try {
                throw new POIException(e);
                catch (IOException e2) {
                    throw new IORuntimeException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
        return this;
    }

    public Word07Writer addPictures(int width, int height, File ... picFiles) {
        XWPFParagraph paragraph = this.doc.createParagraph();
        try {
            for (File picFile : picFiles) {
                XWPFRun run = paragraph.createRun();
                String name = picFile.getName();
                try (BufferedInputStream in = FileUtil.getInputStream((File)picFile);){
                    run.addPicture((InputStream)in, PictureTypeUtil.getType(name), name, Units.toEMU((double)width), Units.toEMU((double)height));
                }
            }
        }
        catch (InvalidFormatException e) {
            throw new POIException(e);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    public Word07Writer flush() throws IORuntimeException {
        return this.flush(this.targetFile);
    }

    public Word07Writer flush(File destFile) throws IORuntimeException {
        Assert.notNull((Object)destFile, (String)"[destFile] is null, and you must call setDestFile(File) first or call flush(OutputStream).", (Object[])new Object[0]);
        return this.flush(FileUtil.getOutputStream((File)destFile, (OpenOption[])new OpenOption[0]), true);
    }

    public Word07Writer flush(OutputStream out) throws IORuntimeException {
        return this.flush(out, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Word07Writer flush(OutputStream out, boolean isCloseOut) throws IORuntimeException {
        Assert.isFalse((boolean)this.isClosed, (String)"WordWriter has been closed!", (Object[])new Object[0]);
        try {
            this.doc.write(out);
            out.flush();
            if (!isCloseOut) return this;
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (!isCloseOut) throw throwable;
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
        return this;
    }

    @Override
    public void close() {
        if (null != this.targetFile) {
            this.flush();
        }
        this.closeWithoutFlush();
    }

    protected void closeWithoutFlush() {
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.doc});
        this.isClosed = true;
    }
}

