/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.cell.setters;

import java.io.File;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.poi.excel.SimpleClientAnchor;
import org.dromara.hutool.poi.excel.cell.setters.CellSetter;
import org.dromara.hutool.poi.excel.shape.ExcelPicType;
import org.dromara.hutool.poi.excel.shape.ExcelPicUtil;
import org.dromara.hutool.poi.excel.writer.ExcelDrawingUtil;

public class PicCellSetter
implements CellSetter {
    private final byte[] pictureData;
    private final ExcelPicType picType;

    public PicCellSetter(byte[] pictureData) {
        this(pictureData, ExcelPicType.PNG);
    }

    public PicCellSetter(File picturefile) {
        this(FileUtil.readBytes((File)picturefile), ExcelPicUtil.getPicType(picturefile));
    }

    public PicCellSetter(byte[] pictureData, ExcelPicType picType) {
        this.pictureData = pictureData;
        this.picType = picType;
    }

    @Override
    public void setValue(Cell cell) {
        Sheet sheet = cell.getSheet();
        int columnIndex = cell.getColumnIndex();
        int rowIndex = cell.getRowIndex();
        ExcelDrawingUtil.drawingPic(sheet, this.pictureData, this.picType, new SimpleClientAnchor(columnIndex, rowIndex, columnIndex + 1, rowIndex + 1));
    }
}

