/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.cell;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.ss.util.SheetUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.poi.excel.ExcelUtil;
import org.dromara.hutool.poi.excel.StyleSet;
import org.dromara.hutool.poi.excel.cell.CellEditor;
import org.dromara.hutool.poi.excel.cell.CellLocation;
import org.dromara.hutool.poi.excel.cell.NullCell;
import org.dromara.hutool.poi.excel.cell.editors.TrimEditor;
import org.dromara.hutool.poi.excel.cell.setters.CellSetterFactory;
import org.dromara.hutool.poi.excel.cell.values.ErrorCellValue;
import org.dromara.hutool.poi.excel.cell.values.NumericCellValue;

public class CellUtil {
    public static Object getCellValue(Cell cell) {
        return CellUtil.getCellValue(cell, false);
    }

    public static Object getCellValue(Cell cell, boolean isTrimCellValue) {
        if (null == cell) {
            return null;
        }
        return CellUtil.getCellValue(cell, cell.getCellType(), isTrimCellValue);
    }

    public static Object getCellValue(Cell cell, CellEditor cellEditor) {
        return CellUtil.getCellValue(cell, null, cellEditor);
    }

    public static Object getCellValue(Cell cell, CellType cellType, boolean isTrimCellValue) {
        return CellUtil.getCellValue(cell, cellType, isTrimCellValue ? new TrimEditor() : null);
    }

    public static Object getCellValue(Cell cell, CellType cellType, CellEditor cellEditor) {
        Object value;
        Cell mergedCell;
        if (null == cell) {
            return null;
        }
        if (cell instanceof NullCell) {
            return null == cellEditor ? null : cellEditor.edit(cell, null);
        }
        if (null == cellType) {
            cellType = cell.getCellType();
        }
        if ((mergedCell = CellUtil.getMergedRegionCell(cell)) != cell) {
            cell = mergedCell;
            cellType = cell.getCellType();
        }
        switch (cellType) {
            case NUMERIC: {
                value = new NumericCellValue(cell).getValue();
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case FORMULA: {
                value = CellUtil.getCellValue(cell, cell.getCachedFormulaResultType(), cellEditor);
                break;
            }
            case BLANK: {
                value = "";
                break;
            }
            case ERROR: {
                value = new ErrorCellValue(cell).getValue();
                break;
            }
            default: {
                value = cell.getStringCellValue();
            }
        }
        return null == cellEditor ? value : cellEditor.edit(cell, value);
    }

    public static void setCellValue(Cell cell, Object value, StyleSet styleSet, boolean isHeader, CellEditor cellEditor) {
        if (null == cell) {
            return;
        }
        if (null != styleSet) {
            cell.setCellStyle(styleSet.getStyleByValueType(value, isHeader));
        }
        CellUtil.setCellValue(cell, value, cellEditor);
    }

    public static void setCellValue(Cell cell, Object value, CellStyle style, CellEditor cellEditor) {
        cell.setCellStyle(style);
        CellUtil.setCellValue(cell, value, cellEditor);
    }

    public static void setCellValue(Cell cell, Object value, CellEditor cellEditor) {
        if (null == cell) {
            return;
        }
        if (null != cellEditor) {
            value = cellEditor.edit(cell, value);
        }
        CellUtil.setCellValue(cell, value);
    }

    public static void setCellValue(Cell cell, Object value) {
        if (null == cell) {
            return;
        }
        if (CellType.BLANK != cell.getCellType()) {
            cell.setBlank();
        }
        CellSetterFactory.createCellSetter(value).setValue(cell);
    }

    public static Cell getCell(Row row, int cellIndex) {
        if (null == row) {
            return null;
        }
        Cell cell = row.getCell(cellIndex);
        if (null == cell) {
            return new NullCell(row, cellIndex);
        }
        return cell;
    }

    public static Cell getOrCreateCell(Row row, int cellIndex) {
        if (null == row) {
            return null;
        }
        Cell cell = row.getCell(cellIndex);
        if (null == cell) {
            cell = row.createCell(cellIndex);
        }
        return cell;
    }

    public static CellRangeAddress getCellRangeAddress(Sheet sheet, String locationRef) {
        CellLocation cellLocation = ExcelUtil.toLocation(locationRef);
        return CellUtil.getCellRangeAddress(sheet, cellLocation.getX(), cellLocation.getY());
    }

    public static CellRangeAddress getCellRangeAddress(Cell cell) {
        return CellUtil.getCellRangeAddress(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex());
    }

    public static CellRangeAddress getCellRangeAddress(Sheet sheet, int x, int y) {
        if (sheet != null) {
            int sheetMergeCount = sheet.getNumMergedRegions();
            for (int i = 0; i < sheetMergeCount; ++i) {
                CellRangeAddress ca = sheet.getMergedRegion(i);
                if (y < ca.getFirstRow() || y > ca.getLastRow() || x < ca.getFirstColumn() || x > ca.getLastColumn()) continue;
                return ca;
            }
        }
        return null;
    }

    public static boolean isMergedRegion(Sheet sheet, String locationRef) {
        CellLocation cellLocation = ExcelUtil.toLocation(locationRef);
        return CellUtil.isMergedRegion(sheet, cellLocation.getX(), cellLocation.getY());
    }

    public static boolean isMergedRegion(Cell cell) {
        return CellUtil.isMergedRegion(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex());
    }

    public static boolean isMergedRegion(Sheet sheet, int x, int y) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            if (y < ca.getFirstRow() || y > ca.getLastRow() || x < ca.getFirstColumn() || x > ca.getLastColumn()) continue;
            return true;
        }
        return false;
    }

    public static int mergingCells(Sheet sheet, int firstRow, int lastRow, int firstColumn, int lastColumn) {
        return CellUtil.mergingCells(sheet, firstRow, lastRow, firstColumn, lastColumn, null);
    }

    public static int mergingCells(Sheet sheet, int firstRow, int lastRow, int firstColumn, int lastColumn, CellStyle cellStyle) {
        CellRangeAddress cellRangeAddress = new CellRangeAddress(firstRow, lastRow, firstColumn, lastColumn);
        CellUtil.setMergeCellStyle(cellStyle, cellRangeAddress, sheet);
        return sheet.addMergedRegion(cellRangeAddress);
    }

    public static Object getMergedRegionValue(Sheet sheet, String locationRef) {
        CellLocation cellLocation = ExcelUtil.toLocation(locationRef);
        return CellUtil.getMergedRegionValue(sheet, cellLocation.getX(), cellLocation.getY());
    }

    public static Object getMergedRegionValue(Sheet sheet, int x, int y) {
        return CellUtil.getCellValue(SheetUtil.getCell((Sheet)sheet, (int)x, (int)y));
    }

    public static Cell getMergedRegionCell(Cell cell) {
        if (null == cell) {
            return null;
        }
        return (Cell)ObjUtil.defaultIfNull((Object)CellUtil.getCellIfMergedRegion(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex()), (Object)cell);
    }

    public static Cell getMergedRegionCell(Sheet sheet, int x, int y) {
        return (Cell)ObjUtil.defaultIfNull((Object)CellUtil.getCellIfMergedRegion(sheet, x, y), () -> SheetUtil.getCell((Sheet)sheet, (int)y, (int)x));
    }

    public static void setComment(Cell cell, String commentText, String commentAuthor) {
        CellUtil.setComment(cell, commentText, commentAuthor, null);
    }

    public static void setComment(Cell cell, String commentText, String commentAuthor, ClientAnchor anchor) {
        Sheet sheet = cell.getSheet();
        CreationHelper factory = sheet.getWorkbook().getCreationHelper();
        if (anchor == null) {
            anchor = factory.createClientAnchor();
            anchor.setCol1(cell.getColumnIndex() + 1);
            anchor.setCol2(cell.getColumnIndex() + 3);
            anchor.setRow1(cell.getRowIndex());
            anchor.setRow2(cell.getRowIndex() + 2);
            anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        }
        Comment comment = sheet.createDrawingPatriarch().createCellComment(anchor);
        comment.setAddress(cell.getAddress());
        comment.setString(factory.createRichTextString(commentText));
        if (null != commentAuthor) {
            comment.setAuthor(commentAuthor);
        }
        cell.setCellComment(comment);
    }

    private static Cell getCellIfMergedRegion(Sheet sheet, int x, int y) {
        for (CellRangeAddress ca : sheet.getMergedRegions()) {
            if (!ca.isInRange(y, x)) continue;
            return SheetUtil.getCell((Sheet)sheet, (int)ca.getFirstRow(), (int)ca.getFirstColumn());
        }
        return null;
    }

    private static void setMergeCellStyle(CellStyle cellStyle, CellRangeAddress cellRangeAddress, Sheet sheet) {
        if (null != cellStyle) {
            RegionUtil.setBorderTop((BorderStyle)cellStyle.getBorderTop(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderRight((BorderStyle)cellStyle.getBorderRight(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderBottom((BorderStyle)cellStyle.getBorderBottom(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderLeft((BorderStyle)cellStyle.getBorderLeft(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setTopBorderColor((int)cellStyle.getTopBorderColor(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setRightBorderColor((int)cellStyle.getRightBorderColor(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setLeftBorderColor((int)cellStyle.getLeftBorderColor(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBottomBorderColor((int)cellStyle.getBottomBorderColor(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
        }
    }
}

