/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.setting;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.net.url.UrlUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;

public class GroupedSet
extends HashMap<String, LinkedHashSet<String>> {
    private static final long serialVersionUID = -8430706353275835496L;
    private static final String COMMENT_FLAG_PRE = "#";
    private static final char[] GROUP_SURROUND = new char[]{'[', ']'};
    private Charset charset;
    private URL groupedSetUrl;

    public GroupedSet(Charset charset) {
        this.charset = charset;
    }

    public GroupedSet(String pathBaseClassLoader, Charset charset) {
        URL url;
        if (null == pathBaseClassLoader) {
            pathBaseClassLoader = "";
        }
        if ((url = UrlUtil.getURL((String)pathBaseClassLoader)) == null) {
            throw new RuntimeException(StrUtil.format((CharSequence)"Can not find GroupSet file: [{}]", (Object[])new Object[]{pathBaseClassLoader}));
        }
        this.init(url, charset);
    }

    public GroupedSet(File configFile, Charset charset) {
        if (configFile == null) {
            throw new RuntimeException("Null GroupSet file!");
        }
        URL url = UrlUtil.getURL((File)configFile);
        this.init(url, charset);
    }

    public GroupedSet(String path, Class<?> clazz, Charset charset) {
        URL url = UrlUtil.getURL((String)path, clazz);
        if (url == null) {
            throw new RuntimeException(StrUtil.format((CharSequence)"Can not find GroupSet file: [{}]", (Object[])new Object[]{path}));
        }
        this.init(url, charset);
    }

    public GroupedSet(URL url, Charset charset) {
        if (url == null) {
            throw new RuntimeException("Null url define!");
        }
        this.init(url, charset);
    }

    public GroupedSet(String pathBaseClassLoader) {
        this(pathBaseClassLoader, CharsetUtil.UTF_8);
    }

    public boolean init(URL groupedSetUrl, Charset charset) {
        if (groupedSetUrl == null) {
            throw new RuntimeException("Null GroupSet url or charset define!");
        }
        this.charset = charset;
        this.groupedSetUrl = groupedSetUrl;
        return this.load(groupedSetUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean load(URL groupedSetUrl) {
        if (groupedSetUrl == null) {
            throw new RuntimeException("Null GroupSet url define!");
        }
        InputStream settingStream = null;
        try {
            settingStream = groupedSetUrl.openStream();
            this.load(settingStream);
        }
        catch (IOException e) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{settingStream});
                throw throwable;
            }
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{settingStream});
            return bl;
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{settingStream});
        return true;
    }

    public void reload() {
        this.load(this.groupedSetUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream settingStream) throws IOException {
        super.clear();
        BufferedReader reader = null;
        try {
            String line;
            reader = IoUtil.toReader((InputStream)settingStream, (Charset)this.charset);
            LinkedHashSet<String> valueSet = null;
            while ((line = reader.readLine()) != null) {
                if (StrUtil.isBlank((CharSequence)(line = line.trim())) || line.startsWith(COMMENT_FLAG_PRE)) continue;
                if (line.startsWith("\\#")) {
                    line = line.substring(1);
                }
                if (line.charAt(0) == GROUP_SURROUND[0] && line.charAt(line.length() - 1) == GROUP_SURROUND[1]) {
                    String group = line.substring(1, line.length() - 1).trim();
                    valueSet = (LinkedHashSet<String>)super.get(group);
                    if (null == valueSet) {
                        valueSet = new LinkedHashSet<String>();
                    }
                    super.put(group, valueSet);
                    continue;
                }
                if (null == valueSet) {
                    valueSet = new LinkedHashSet<String>();
                    super.put("", valueSet);
                }
                valueSet.add(line);
            }
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{reader});
            throw throwable;
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{reader});
    }

    public String getPath() {
        return this.groupedSetUrl.getPath();
    }

    public Set<String> getGroups() {
        return super.keySet();
    }

    public LinkedHashSet<String> getValues(String group) {
        if (group == null) {
            group = "";
        }
        return (LinkedHashSet)super.get(group);
    }

    public boolean contains(String group, String value, String ... otherValues) {
        if (ArrayUtil.isNotEmpty((Object[])otherValues)) {
            List<String> valueList = Arrays.asList(otherValues);
            valueList.add(value);
            return this.contains(group, valueList);
        }
        LinkedHashSet<String> valueSet = this.getValues(group);
        if (CollUtil.isEmpty(valueSet)) {
            return false;
        }
        return valueSet.contains(value);
    }

    public boolean contains(String group, Collection<String> values) {
        LinkedHashSet<String> valueSet = this.getValues(group);
        if (CollUtil.isEmpty(values) || CollUtil.isEmpty(valueSet)) {
            return false;
        }
        return valueSet.containsAll(values);
    }
}

