/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.setting;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.LineReader;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.io.resource.Resource;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.regex.ReUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.SystemUtil;
import org.dromara.hutool.log.Log;
import org.dromara.hutool.setting.GroupedMap;

public class SettingLoader {
    private static final Log log = Log.get();
    private static final char COMMENT_FLAG_PRE = '#';
    private final Charset charset;
    private final boolean isUseVariable;
    private final GroupedMap groupedMap;
    private char assignFlag = (char)61;
    private String varRegex = "\\$\\{(.*?)\\}";
    private UnaryOperator<String> valueEditor;

    public SettingLoader(GroupedMap groupedMap) {
        this(groupedMap, CharsetUtil.UTF_8, false);
    }

    public SettingLoader(GroupedMap groupedMap, Charset charset, boolean isUseVariable) {
        this.groupedMap = groupedMap;
        this.charset = charset;
        this.isUseVariable = isUseVariable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(Resource resource) {
        if (resource == null) {
            throw new NullPointerException("Null setting url define!");
        }
        log.debug("Load setting file [{}]", new Object[]{resource});
        InputStream settingStream = null;
        try {
            settingStream = resource.getStream();
            this.load(settingStream);
        }
        catch (Exception e) {
            boolean bl;
            try {
                log.error((Throwable)e, "Load setting error!", new Object[0]);
                bl = false;
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{settingStream});
                throw throwable;
            }
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{settingStream});
            return bl;
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{settingStream});
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(InputStream settingStream) throws IOException {
        this.groupedMap.clear();
        LineReader reader = null;
        try {
            String line;
            reader = new LineReader(settingStream, this.charset);
            String group = null;
            while ((line = reader.readLine()) != null) {
                if (StrUtil.isBlank((CharSequence)(line = StrUtil.trim((CharSequence)line))) || StrUtil.startWith((CharSequence)line, (char)'#')) continue;
                if (StrUtil.isWrap((CharSequence)line, (char)'[', (char)']')) {
                    group = StrUtil.trim((CharSequence)line.substring(1, line.length() - 1));
                    continue;
                }
                String[] keyValue = SplitUtil.split((CharSequence)line, (CharSequence)String.valueOf(this.assignFlag), (int)2, (boolean)true, (boolean)false).toArray(new String[0]);
                if (keyValue.length < 2) continue;
                String value = keyValue[1];
                if (null != this.valueEditor) {
                    value = (String)this.valueEditor.apply(value);
                }
                if (this.isUseVariable) {
                    value = this.replaceVar(group, value);
                }
                this.groupedMap.put(group, StrUtil.trim((CharSequence)keyValue[0]), value);
            }
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{reader});
            throw throwable;
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{reader});
    }

    public SettingLoader setVarRegex(String regex) {
        this.varRegex = regex;
        return this;
    }

    public SettingLoader setAssignFlag(char assignFlag) {
        this.assignFlag = assignFlag;
        return this;
    }

    public SettingLoader setValueEditor(UnaryOperator<String> valueEditor) {
        this.valueEditor = valueEditor;
        return this;
    }

    public void store(String absolutePath) {
        this.store(FileUtil.touch((String)absolutePath));
    }

    public void store(File file) {
        Assert.notNull((Object)file, (String)"File to store must be not null !", (Object[])new Object[0]);
        log.debug("Store Setting to [{}]...", new Object[]{file.getAbsolutePath()});
        PrintWriter writer = null;
        try {
            writer = FileUtil.getPrintWriter((File)file, (Charset)this.charset, (boolean)false);
            this.store(writer);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{writer});
            throw throwable;
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{writer});
    }

    private synchronized void store(PrintWriter writer) {
        for (Map.Entry<String, LinkedHashMap<String, String>> groupEntry : this.groupedMap.entrySet()) {
            writer.println(StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{Character.valueOf('['), groupEntry.getKey(), Character.valueOf(']')}));
            for (Map.Entry<String, String> entry : groupEntry.getValue().entrySet()) {
                writer.println(StrUtil.format((CharSequence)"{} {} {}", (Object[])new Object[]{entry.getKey(), Character.valueOf(this.assignFlag), entry.getValue()}));
            }
        }
    }

    private String replaceVar(String group, String value) {
        Set vars = (Set)ReUtil.findAll((String)this.varRegex, (CharSequence)value, (int)0, new HashSet());
        for (String var : vars) {
            List groupAndKey;
            String key = ReUtil.get((String)this.varRegex, (CharSequence)var, (int)1);
            if (!StrUtil.isNotBlank((CharSequence)key)) continue;
            String varValue = this.groupedMap.get(group, key);
            if (null == varValue && (groupAndKey = SplitUtil.split((CharSequence)key, (CharSequence)".", (int)2, (boolean)true, (boolean)false)).size() > 1) {
                varValue = this.groupedMap.get((CharSequence)groupAndKey.get(0), (CharSequence)groupAndKey.get(1));
            }
            if (null == varValue) {
                varValue = SystemUtil.get((String)key);
            }
            if (null == varValue) continue;
            value = value.replace(var, varValue);
        }
        return value;
    }
}

