/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.setting.props;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.func.LambdaInfo;
import org.dromara.hutool.core.func.LambdaUtil;
import org.dromara.hutool.core.func.SerFunction;
import org.dromara.hutool.core.func.SerSupplier;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.io.resource.Resource;
import org.dromara.hutool.core.io.resource.ResourceUtil;
import org.dromara.hutool.core.io.resource.UrlResource;
import org.dromara.hutool.core.io.watch.SimpleWatcher;
import org.dromara.hutool.core.io.watch.WatchMonitor;
import org.dromara.hutool.core.io.watch.WatchUtil;
import org.dromara.hutool.core.io.watch.Watcher;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.getter.TypeGetter;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.log.LogUtil;

public final class Props
extends Properties
implements TypeGetter<CharSequence> {
    private static final long serialVersionUID = 1935981579709590740L;
    public static final String EXT_NAME = "properties";
    private Resource resource;
    private WatchMonitor watchMonitor;
    private transient Charset charset = CharsetUtil.ISO_8859_1;

    public static Props of() {
        return new Props();
    }

    public static Props of(String resource) {
        return new Props(resource);
    }

    public static Props of(String resource, Charset charset) {
        return new Props(resource, charset);
    }

    public Props() {
    }

    public Props(String path) {
        this(path, null);
    }

    public Props(String path, Charset charset) {
        Assert.notBlank((CharSequence)path, (String)"Blank properties file path !", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(ResourceUtil.getResource((String)path));
    }

    public Props(File propertiesFile) {
        this(propertiesFile, null);
    }

    public Props(File propertiesFile, Charset charset) {
        Assert.notNull((Object)propertiesFile, (String)"Null properties file!", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(ResourceUtil.getResource((File)propertiesFile));
    }

    public Props(Resource resource, Charset charset) {
        Assert.notNull((Object)resource, (String)"Null properties URL !", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(resource);
    }

    public Props(Properties properties) {
        if (MapUtil.isNotEmpty((Map)properties)) {
            this.putAll((Map<?, ?>)properties);
        }
    }

    public void load(URL url) {
        this.load((Resource)new UrlResource(url));
    }

    public void load(Resource resource) {
        Assert.notNull((Object)resource, (String)"Props resource must be not null!", (Object[])new Object[0]);
        this.resource = resource;
        ResourceUtil.loadTo((Properties)this, (Resource)resource, (Charset)this.charset);
    }

    public void load() {
        this.load(this.resource);
    }

    public void autoLoad(boolean autoReload) {
        if (autoReload) {
            Assert.notNull((Object)this.resource, (String)"Properties resource must be not null!", (Object[])new Object[0]);
            if (null != this.watchMonitor) {
                this.watchMonitor.close();
            }
            this.watchMonitor = WatchUtil.createModify((URL)this.resource.getUrl(), (Watcher)new SimpleWatcher(){

                public void onModify(WatchEvent<?> event, Path currentPath) {
                    Props.this.load();
                }
            });
            this.watchMonitor.start();
        } else {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.watchMonitor});
            this.watchMonitor = null;
        }
    }

    public Object getObj(CharSequence key, Object defaultValue) {
        return ObjUtil.defaultIfNull((Object)this.getProperty(StrUtil.str((CharSequence)key)), (Object)defaultValue);
    }

    public <P, T> T get(SerFunction<P, T> func) {
        LambdaInfo lambdaInfo = LambdaUtil.resolve(func);
        return (T)this.get(lambdaInfo.getFieldName(), lambdaInfo.getReturnType());
    }

    public String getAndRemoveStr(String ... keys) {
        String key;
        Object value = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && null == (value = this.remove(key = stringArray[i])); ++i) {
        }
        return (String)value;
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this);
        return properties;
    }

    public <T> T toBean(Class<T> beanClass) {
        return this.toBean(beanClass, null);
    }

    public <T> T toBean(Class<T> beanClass, String prefix) {
        Object bean = ConstructorUtil.newInstanceIfPossible(beanClass);
        return (T)this.fillBean(bean, prefix);
    }

    public <T> T fillBean(T bean, String prefix) {
        prefix = StrUtil.emptyIfNull((CharSequence)StrUtil.addSuffixIfNot((CharSequence)prefix, (CharSequence)"."));
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key = (String)entry.getKey();
            if (!StrUtil.startWith((CharSequence)key, (CharSequence)prefix)) continue;
            try {
                BeanUtil.setProperty(bean, (String)StrUtil.subSuf((CharSequence)key, (int)prefix.length()), (Object)entry.getValue());
            }
            catch (Exception e) {
                LogUtil.debug((String)"Ignore property: [{}],because of: {}", (Object[])new Object[]{key, e});
            }
        }
        return bean;
    }

    public void set(String key, Object value) {
        super.setProperty(key, value.toString());
    }

    public Props setFields(SerSupplier<?> ... fields) {
        Arrays.stream(fields).forEach((? super T f) -> this.set(LambdaUtil.getFieldName((Serializable)f), f.get()));
        return this;
    }

    public void store(String absolutePath) throws IORuntimeException {
        BufferedWriter writer = null;
        try {
            writer = FileUtil.getWriter((String)absolutePath, (Charset)this.charset, (boolean)false);
            super.store(writer, null);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException((Throwable)e, "Store properties to [{}] error!", new Object[]{absolutePath});
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{writer});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{writer});
    }

    public void store(String path, Class<?> clazz) {
        this.store(FileUtil.getAbsolutePath((String)path, clazz));
    }
}

