/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.setting;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.text.StrUtil;

public class GroupedMap
extends LinkedHashMap<String, LinkedHashMap<String, String>> {
    private static final long serialVersionUID = -7777365130776081931L;
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.cacheLock.writeLock();
    private int size = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(CharSequence group, CharSequence key) {
        this.readLock.lock();
        try {
            Object map = this.get(StrUtil.emptyIfNull((CharSequence)group));
            if (MapUtil.isNotEmpty((Map)map)) {
                String string = (String)((LinkedHashMap)map).get(StrUtil.str((CharSequence)key));
                return string;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return null;
    }

    @Override
    public LinkedHashMap<String, String> get(Object key) {
        this.readLock.lock();
        try {
            LinkedHashMap linkedHashMap = (LinkedHashMap)super.get(key);
            return linkedHashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int size() {
        this.writeLock.lock();
        try {
            if (this.size < 0) {
                this.size = 0;
                for (LinkedHashMap value : this.values()) {
                    this.size += value.size();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(String group, String key, String value) {
        group = StrUtil.emptyIfNull((CharSequence)group).trim();
        this.writeLock.lock();
        try {
            LinkedHashMap valueMap = this.computeIfAbsent(group, k -> new LinkedHashMap());
            this.size = -1;
            String string = valueMap.put(key, value);
            return string;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public GroupedMap putAll(String group, Map<? extends String, ? extends String> m) {
        for (Map.Entry<? extends String, ? extends String> entry : m.entrySet()) {
            this.put(group, entry.getKey(), entry.getValue());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String remove(String group, String key) {
        group = StrUtil.emptyIfNull((CharSequence)group).trim();
        this.writeLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty((Map)valueMap)) {
                String string = (String)((HashMap)valueMap).remove(key);
                return string;
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(String group) {
        group = StrUtil.emptyIfNull((CharSequence)group).trim();
        this.readLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty((Map)valueMap)) {
                boolean bl = ((HashMap)valueMap).isEmpty();
                return bl;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String group, String key) {
        group = StrUtil.emptyIfNull((CharSequence)group).trim();
        this.readLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty((Map)valueMap)) {
                boolean bl = ((HashMap)valueMap).containsKey(key);
                return bl;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(String group, String value) {
        group = StrUtil.emptyIfNull((CharSequence)group).trim();
        this.readLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty((Map)valueMap)) {
                boolean bl = ((LinkedHashMap)valueMap).containsValue(value);
                return bl;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return false;
    }

    public GroupedMap clear(String group) {
        group = StrUtil.emptyIfNull((CharSequence)group).trim();
        this.writeLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty((Map)valueMap)) {
                ((LinkedHashMap)valueMap).clear();
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return this;
    }

    @Override
    public Set<String> keySet() {
        this.readLock.lock();
        try {
            Set<String> set = super.keySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet(String group) {
        group = StrUtil.emptyIfNull((CharSequence)group).trim();
        this.readLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty((Map)valueMap)) {
                Set<String> set = ((LinkedHashMap)valueMap).keySet();
                return set;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> values(String group) {
        group = StrUtil.emptyIfNull((CharSequence)group).trim();
        this.readLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty((Map)valueMap)) {
                Collection<String> collection = ((LinkedHashMap)valueMap).values();
                return collection;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return Collections.emptyList();
    }

    @Override
    public Set<Map.Entry<String, LinkedHashMap<String, String>>> entrySet() {
        this.readLock.lock();
        try {
            Set<Map.Entry<String, LinkedHashMap<String, String>>> set = super.entrySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Map.Entry<String, String>> entrySet(String group) {
        group = StrUtil.emptyIfNull((CharSequence)group).trim();
        this.readLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty((Map)valueMap)) {
                Set<Map.Entry<String, String>> set = ((LinkedHashMap)valueMap).entrySet();
                return set;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return Collections.emptySet();
    }

    @Override
    public String toString() {
        this.readLock.lock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

