/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.socket.aio;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import org.dromara.hutool.socket.ChannelUtil;
import org.dromara.hutool.socket.SocketConfig;
import org.dromara.hutool.socket.aio.AioSession;
import org.dromara.hutool.socket.aio.IoAction;

public class AioClient
implements Closeable {
    private final AioSession session;

    public AioClient(InetSocketAddress address, IoAction<ByteBuffer> ioAction) {
        this(address, ioAction, new SocketConfig());
    }

    public AioClient(InetSocketAddress address, IoAction<ByteBuffer> ioAction, SocketConfig config) {
        this(AioClient.createChannel(address, config.getThreadPoolSize()), ioAction, config);
    }

    public AioClient(AsynchronousSocketChannel channel, IoAction<ByteBuffer> ioAction, SocketConfig config) {
        this.session = new AioSession(channel, ioAction, config);
        ioAction.accept(this.session);
    }

    public <T> AioClient setOption(SocketOption<T> name, T value) throws IOException {
        this.session.getChannel().setOption((SocketOption)name, (Object)value);
        return this;
    }

    public IoAction<ByteBuffer> getIoAction() {
        return this.session.getIoAction();
    }

    public AioClient read() {
        this.session.read();
        return this;
    }

    public AioClient write(ByteBuffer data) {
        this.session.write(data);
        return this;
    }

    @Override
    public void close() {
        this.session.close();
    }

    private static AsynchronousSocketChannel createChannel(InetSocketAddress address, int poolSize) {
        return ChannelUtil.connect(ChannelUtil.createFixedGroup(poolSize), address);
    }
}

