/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.socket.aio;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.thread.ThreadFactoryBuilder;
import org.dromara.hutool.core.thread.ThreadUtil;
import org.dromara.hutool.log.Log;
import org.dromara.hutool.socket.SocketConfig;
import org.dromara.hutool.socket.aio.AcceptHandler;
import org.dromara.hutool.socket.aio.IoAction;

public class AioServer
implements Closeable {
    private static final Log log = Log.get();
    private static final AcceptHandler ACCEPT_HANDLER = new AcceptHandler();
    private AsynchronousChannelGroup group;
    private AsynchronousServerSocketChannel channel;
    protected IoAction<ByteBuffer> ioAction;
    protected final SocketConfig config;

    public AioServer(int port) {
        this(new InetSocketAddress(port), new SocketConfig());
    }

    public AioServer(InetSocketAddress address, SocketConfig config) {
        this.config = config;
        this.init(address);
    }

    public AioServer init(InetSocketAddress address) {
        try {
            this.group = AsynchronousChannelGroup.withFixedThreadPool(this.config.getThreadPoolSize(), ThreadFactoryBuilder.of().setNamePrefix("Hutool-socket-").build());
            this.channel = AsynchronousServerSocketChannel.open(this.group).bind(address);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    public void start(boolean sync) {
        this.doStart(sync);
    }

    public <T> AioServer setOption(SocketOption<T> name, T value) throws IOException {
        this.channel.setOption((SocketOption)name, (Object)value);
        return this;
    }

    public IoAction<ByteBuffer> getIoAction() {
        return this.ioAction;
    }

    public AioServer setIoAction(IoAction<ByteBuffer> ioAction) {
        this.ioAction = ioAction;
        return this;
    }

    public AsynchronousServerSocketChannel getChannel() {
        return this.channel;
    }

    public AioServer accept() {
        this.channel.accept(this, ACCEPT_HANDLER);
        return this;
    }

    public boolean isOpen() {
        return null != this.channel && this.channel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.channel});
        if (null != this.group && !this.group.isShutdown()) {
            try {
                this.group.shutdownNow();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        AioServer aioServer = this;
        synchronized (aioServer) {
            this.notify();
        }
    }

    private void doStart(boolean sync) {
        log.debug("Aio Server started, waiting for accept.", new Object[0]);
        this.accept();
        if (sync) {
            ThreadUtil.sync((Object)this);
        }
    }
}

