/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.socket.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.thread.ThreadUtil;
import org.dromara.hutool.log.Log;
import org.dromara.hutool.socket.SocketRuntimeException;
import org.dromara.hutool.socket.nio.ChannelHandler;

public class NioClient
implements Closeable {
    private static final Log log = Log.get();
    private Selector selector;
    private SocketChannel channel;
    private ChannelHandler handler;

    public NioClient(String host, int port) {
        this.init(new InetSocketAddress(host, port));
    }

    public NioClient(InetSocketAddress address) {
        this.init(address);
    }

    public NioClient init(InetSocketAddress address) {
        try {
            this.channel = SocketChannel.open();
            this.channel.configureBlocking(false);
            this.channel.connect(address);
            this.selector = Selector.open();
            this.channel.register(this.selector, 1);
            while (!this.channel.finishConnect()) {
            }
        }
        catch (IOException e) {
            this.close();
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    public NioClient setChannelHandler(ChannelHandler handler) {
        this.handler = handler;
        return this;
    }

    public void listen() {
        ThreadUtil.execute(() -> {
            try {
                this.doListen();
            }
            catch (IOException e) {
                log.error("Listen failed", new Object[]{e});
            }
        });
    }

    private void doListen() throws IOException {
        while (this.selector.isOpen() && 0 != this.selector.select()) {
            Iterator<SelectionKey> keyIter = this.selector.selectedKeys().iterator();
            while (keyIter.hasNext()) {
                this.handle(keyIter.next());
                keyIter.remove();
            }
        }
    }

    private void handle(SelectionKey key) {
        if (key.isReadable()) {
            SocketChannel socketChannel = (SocketChannel)key.channel();
            try {
                this.handler.handle(socketChannel);
            }
            catch (Throwable e) {
                throw new SocketRuntimeException(e);
            }
        }
    }

    public NioClient write(ByteBuffer ... datas) {
        try {
            this.channel.write(datas);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    @Override
    public void close() {
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.selector});
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.channel});
    }
}

