/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.ExecutionException;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.thread.ThreadFactoryBuilder;
import org.dromara.hutool.socket.SocketRuntimeException;

public class ChannelUtil {
    public static AsynchronousChannelGroup createFixedGroup(int poolSize) {
        try {
            return AsynchronousChannelGroup.withFixedThreadPool(poolSize, ThreadFactoryBuilder.of().setNamePrefix("Huool-socket-").build());
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static AsynchronousSocketChannel connect(AsynchronousChannelGroup group, InetSocketAddress address) {
        AsynchronousSocketChannel channel;
        try {
            channel = AsynchronousSocketChannel.open(group);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        try {
            channel.connect(address).get();
        }
        catch (InterruptedException | ExecutionException e) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{channel});
            throw new SocketRuntimeException(e);
        }
        return channel;
    }
}

