/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.swing.img;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.io.IORuntimeException;

public class ImgMetaUtil {
    public static int getOrientation(File file) throws IORuntimeException {
        Metadata metadata;
        try {
            metadata = ImageMetadataReader.readMetadata((File)file);
        }
        catch (ImageProcessingException e) {
            throw new HutoolException((Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ImgMetaUtil.getOrientation(metadata);
    }

    public static int getOrientation(InputStream in) throws IORuntimeException {
        Metadata metadata;
        try {
            metadata = ImageMetadataReader.readMetadata((InputStream)in);
        }
        catch (ImageProcessingException e) {
            throw new HutoolException((Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ImgMetaUtil.getOrientation(metadata);
    }

    private static int getOrientation(Metadata metadata) {
        for (Directory directory : metadata.getDirectories()) {
            for (Tag tag : directory.getTags()) {
                if (!"Orientation".equals(tag.getTagName())) continue;
                String orientation = tag.getDescription();
                if (orientation.contains("90")) {
                    return 90;
                }
                if (orientation.contains("180")) {
                    return 180;
                }
                if (!orientation.contains("270")) continue;
                return 270;
            }
        }
        return 0;
    }
}

