/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.amqp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.amqp.MQMessage;
import org.dromara.mendmix.common.GlobalContext;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.async.StandardThreadExecutor;
import org.dromara.mendmix.common.util.ExceptionFormatUtils;
import org.dromara.mendmix.common.util.ResourceUtils;

public class MQContext {
    public static final String APPLICATION = "application";
    public static final String MQ_CONTEXT_IGNORE_LOGGING = "mq_ignore_logging";
    private String instance;
    private String providerName;
    private String groupName;
    private boolean producerEnabled;
    private boolean consumerEnabled;
    private String namespacePrefix;
    private List<String> internalTopics;
    private boolean asyncConsumeEnabled;
    private List<String> ignoreLogTopics = new ArrayList<String>();
    private int processThreads = 0;
    private int batchSize;
    private long consumeMaxInterval = -1L;
    private int consumeMaxRetryTimes = -1;
    private boolean loghandlerEnabled;
    private static ThreadPoolExecutor logHandleExecutor;
    private Map<String, List<String>> consumeAllowFilters = new HashMap<String, List<String>>();
    private Map<String, List<String>> consumeIgnoreFilters = new HashMap<String, List<String>>();
    private Properties properties;

    public MQContext(String instance) {
        this.instance = instance;
        this.providerName = ResourceUtils.getAndValidateProperty((String)(instance + ".amqp.provider"));
        if ("none".equals(this.providerName)) {
            return;
        }
        this.producerEnabled = Boolean.parseBoolean(ResourceUtils.getProperty((String)(instance + ".amqp.producer.enabled")));
        this.consumerEnabled = Boolean.parseBoolean(ResourceUtils.getProperty((String)(instance + ".amqp.consumer.enabled")));
        String namespace = ResourceUtils.getProperty((String)(instance + ".amqp.namespace"));
        if (StringUtils.isNotBlank((CharSequence)namespace) && !"none".equals(namespace)) {
            this.namespacePrefix = namespace + "_";
        }
        String groupName = ResourceUtils.getProperty((String)(instance + ".amqp.groupName"), (String)GlobalContext.APPID);
        if (ResourceUtils.getBoolean((String)(instance + ".amqp.consumer.parallel"))) {
            groupName = groupName + "_" + GlobalContext.getWorkerId();
        }
        this.groupName = this.rebuildWithNamespace(groupName);
        this.asyncConsumeEnabled = Boolean.parseBoolean(ResourceUtils.getProperty((String)(instance + ".amqp.consumer.async.enabled"), (String)"true"));
        this.processThreads = ResourceUtils.getInt((String)(instance + ".amqp.consumer.processThreads"), (int)20);
        this.batchSize = ResourceUtils.getInt((String)(instance + ".amqp.consumer.fetch.batchSize"), (int)1);
        this.consumeMaxInterval = ResourceUtils.getLong((String)(instance + ".amqp.consumer.maxInterval.ms"), (long)86400000L);
        this.consumeMaxRetryTimes = ResourceUtils.getInt((String)(instance + ".amqp.consumer.maxRetryTimes"), (int)10);
        this.loghandlerEnabled = ResourceUtils.getBoolean((String)(instance + ".amqp.message.logging.enabled"));
        if (this.loghandlerEnabled && logHandleExecutor == null) {
            StandardThreadExecutor.StandardThreadFactory threadFactory = new StandardThreadExecutor.StandardThreadFactory("logHandleExecutor");
            logHandleExecutor = new StandardThreadExecutor(1, 10, 60L, TimeUnit.SECONDS, 5000, (ThreadFactory)threadFactory, (RejectedExecutionHandler)new ThreadPoolExecutor.DiscardPolicy());
        }
        this.loghandlerEnabled = false;
        if (!"eventbus".equals(this.getProviderName()) && ResourceUtils.containsProperty((String)(instance + ".amqp.internalTopics"))) {
            this.internalTopics = ResourceUtils.getList((String)(instance + ".amqp.internalTopics"));
        }
        this.properties = this.parseProfileProperties();
        this.initConsumeFilterRules();
    }

    private void initConsumeFilterRules() {
        if (this.isConsumerEnabled()) {
            this.consumeIgnoreFilters.clear();
            this.consumeAllowFilters.clear();
            Map mappingValues = ResourceUtils.getMappingValues((String)(this.instance + ".amqp.consumer.ignoreRules"));
            mappingValues.forEach((k, v) -> {
                String[] parts = StringUtils.split((String)v, (String)":");
                String[] values = parts.length == 1 ? StringUtils.split((String)v, (String)",;") : StringUtils.split((String)parts[1], (String)",;");
                if ("blacklist".equals(parts[0])) {
                    this.consumeIgnoreFilters.put((String)k, Arrays.asList(values));
                } else {
                    this.consumeAllowFilters.put((String)k, Arrays.asList(values));
                }
            });
        }
    }

    public String getInstance() {
        return this.instance;
    }

    public String rebuildWithNamespace(String name) {
        if (this.namespacePrefix == null) {
            return name;
        }
        if (name == null || name.startsWith(this.namespacePrefix)) {
            return name;
        }
        return this.namespacePrefix + name;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean isProducerEnabled() {
        return this.producerEnabled;
    }

    public boolean isConsumerEnabled() {
        return this.consumerEnabled;
    }

    public Properties getProfileProperties() {
        return this.properties;
    }

    public String getProfileProperties(String key) {
        return this.properties.getProperty(key);
    }

    private Properties parseProfileProperties() {
        Properties properties = new Properties();
        String prefix = String.format("%s.amqp.%s", this.instance, this.providerName);
        Set<Map.Entry<Object, Object>> entrySet = ResourceUtils.getAllProperties((String)prefix).entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String key = entry.getKey().toString();
            String profileKey = key.contains("[") ? StringUtils.split((String)entry.getKey().toString(), (String)"[]")[1] : key.substring(prefix.length() + 1);
            properties.setProperty(profileKey, entry.getValue().toString());
        }
        return properties;
    }

    public boolean isAsyncConsumeEnabled() {
        return this.asyncConsumeEnabled;
    }

    public boolean isLogEnabled() {
        return this.loghandlerEnabled;
    }

    public int getMaxProcessThreads() {
        return this.processThreads;
    }

    public long getConsumeMaxInterval() {
        return this.consumeMaxInterval;
    }

    public int getConsumeMaxRetryTimes() {
        return this.consumeMaxRetryTimes;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public String getStateCheckUrl() {
        return null;
    }

    public boolean matchedOnFilter(MQMessage message) {
        if (this.consumeAllowFilters.isEmpty() && this.consumeIgnoreFilters.isEmpty()) {
            return true;
        }
        Map<String, String> headers = message.getHeaders();
        if (headers == null || headers.isEmpty()) {
            return true;
        }
        boolean matched = true;
        for (String headerName : headers.keySet()) {
            if (this.consumeAllowFilters.containsKey(headerName)) {
                matched = this.consumeAllowFilters.get(headerName).contains(headers.get(headerName));
            } else if (this.consumeIgnoreFilters.containsKey(headerName)) {
                boolean bl = matched = !this.consumeIgnoreFilters.get(headerName).contains(headers.get(headerName));
            }
            if (matched) continue;
            break;
        }
        return matched;
    }

    public void updateConfigs(Properties properties) {
        String prefix = this.instance + ".amqp.consumer.ignoreRules";
        if (properties.keySet().stream().anyMatch(o -> o.toString().startsWith(prefix))) {
            this.initConsumeFilterRules();
        }
    }

    public static void processMessageLog(MQContext context, MQMessage message, ActionType actionType, Throwable ex) {
        if (!context.isLogEnabled() || ThreadLocalContext.exists((String)MQ_CONTEXT_IGNORE_LOGGING)) {
            return;
        }
        if (context.ignoreLogTopics.contains(message.getTopic())) {
            return;
        }
        message.setProcessTime(System.currentTimeMillis());
        try {
            logHandleExecutor.execute(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        catch (Exception e) {
            System.err.println(ExceptionFormatUtils.buildExceptionMessages((Throwable)e, (int)2));
        }
    }

    public boolean hasInternalTopics() {
        return this.internalTopics != null && !this.internalTopics.isEmpty();
    }

    public boolean isInternalTopicMode(String topic) {
        if (this.internalTopics == null) {
            return false;
        }
        return this.internalTopics.contains(topic);
    }

    public static void close() {
        if (logHandleExecutor != null) {
            logHandleExecutor.shutdown();
            logHandleExecutor = null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MQContext");
        builder.append("\n -instance:").append(this.instance);
        builder.append("\n -providerName:").append(this.providerName);
        builder.append("\n -groupName:").append(this.groupName);
        builder.append("\n -namespacePrefix:").append(this.namespacePrefix);
        builder.append("\n -producerEnabled:").append(this.isProducerEnabled());
        builder.append("\n -consumerEnabled:").append(this.isConsumerEnabled());
        if (!this.consumeAllowFilters.isEmpty()) {
            builder.append("\n -consumeWhitelistRules:").append(this.consumeAllowFilters);
        }
        if (!this.consumeIgnoreFilters.isEmpty()) {
            builder.append("\n -consumeBlacklistRules:").append(this.consumeIgnoreFilters);
        }
        return builder.toString();
    }

    public static enum ActionType {
        pub,
        sub;

    }
}

