/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.amqp;

import java.util.Map;
import org.dromara.mendmix.amqp.MQContext;
import org.dromara.mendmix.amqp.MQMessage;
import org.dromara.mendmix.amqp.MQProducer;
import org.dromara.mendmix.amqp.adapter.AbstractProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQInstanceDelegate {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.amqp.adapter");
    private static Map<String, MQContext> contexts;
    private static Map<String, MQProducer> producers;

    private MQInstanceDelegate() {
    }

    public static void init(Map<String, MQContext> contexts, Map<String, MQProducer> producers) {
        MQInstanceDelegate.contexts = contexts;
        MQInstanceDelegate.producers = producers;
    }

    public static void send(String instance, MQMessage message) {
        if (!producers.containsKey(instance)) {
            logger.warn(">>MQProducer not Initialization for:{}", (Object)instance);
            return;
        }
        MQInstanceDelegate.sendMessage(contexts.get(instance), producers.get(instance), message, false);
    }

    public static void asyncSend(String instance, MQMessage message) {
        if (!producers.containsKey(instance)) {
            logger.warn(">>MQProducer not Initialization for:{}", (Object)instance);
            return;
        }
        MQInstanceDelegate.sendMessage(contexts.get(instance), producers.get(instance), message, true);
    }

    public static void sendTxMessage(String instance, MQMessage message) {
        if (!producers.containsKey(instance)) {
            logger.warn(">>MQProducer not Initialization for:{}", (Object)instance);
            return;
        }
        MQInstanceDelegate.sendTxMessage(contexts.get(instance), producers.get(instance), message);
    }

    public static void send(MQMessage message) {
        MQInstanceDelegate.send("application", message);
    }

    public static void asyncSend(MQMessage message) {
        MQInstanceDelegate.asyncSend("application", message);
    }

    public static void sendTxMessage(MQMessage message) {
        MQInstanceDelegate.sendTxMessage("application", message);
    }

    private static void sendMessage(MQContext context, MQProducer producer, MQMessage message, boolean async) {
        message.setTopic(context.rebuildWithNamespace(message.getTopic()));
        if (context.isInternalTopicMode(message.getTopic())) {
            AbstractProducer.getInternalMQProducer().sendMessage(message, async);
        } else {
            producer.sendMessage(message, async);
        }
    }

    private static void sendTxMessage(MQContext context, MQProducer producer, MQMessage message) {
        message.setTopic(context.rebuildWithNamespace(message.getTopic()));
        if (context.isInternalTopicMode(message.getTopic())) {
            AbstractProducer.getInternalMQProducer().sendMessage(message, false);
        } else {
            producer.sendTxMessage(message);
        }
    }
}

