/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.amqp;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.guid.GUID;
import org.dromara.mendmix.common.http.HttpRequestEntity;
import org.dromara.mendmix.common.http.HttpResponseEntity;
import org.dromara.mendmix.common.model.AuthUser;
import org.dromara.mendmix.common.util.BeanUtils;
import org.dromara.mendmix.common.util.JsonUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MQMessage {
    private static final String SKYWALKING_HEADER_PREFIX = "sw";
    private String txId;
    private String topic;
    private String tag;
    private String bizKey;
    private Object body;
    @JsonIgnore
    private Long processTime;
    private Long deliverTime;
    private String msgId;
    private Integer partition;
    @JsonIgnore
    private long offset;
    private int consumeTimes;
    @JsonIgnore
    private Object originMessage;
    @JsonIgnore
    private String partitionKey;
    private Map<String, String> headers;

    public MQMessage() {
    }

    public static MQMessage build(String json) {
        String tenantId;
        MQMessage message = (MQMessage)JsonUtils.toObject((String)json, MQMessage.class);
        if (!BeanUtils.isSimpleDataType(message.body.getClass())) {
            message.setBody(JsonUtils.toJson((Object)message.body));
        }
        if (message.getTenantId() == null && (tenantId = JsonUtils.getJsonNodeValue((String)json, (String)"tenantId")) != null) {
            message.addHeader("x-tenant-id", tenantId);
        }
        return message;
    }

    public MQMessage(String topic, Object body) {
        this(topic, null, body);
    }

    public MQMessage(String topic, String bizKey, Object body) {
        this(topic, null, bizKey, body);
    }

    public MQMessage(String topic, String tag, String bizKey, Object body) {
        this.topic = topic;
        this.tag = tag;
        this.bizKey = bizKey;
        this.body = body instanceof byte[] ? new String((byte[])body, StandardCharsets.UTF_8) : body;
    }

    @JsonIgnore
    public String getTenantId() {
        return this.getHeaderValue("x-tenant-id");
    }

    @JsonIgnore
    public String getBusinessUnitId() {
        return this.getHeaderValue("x-bunit-id");
    }

    @JsonIgnore
    public String getRequestId() {
        return this.getHeaderValue("x-request-id");
    }

    @JsonIgnore
    public String getProduceBy() {
        return this.getHeaderValue("x-user-id");
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getBizKey() {
        return this.bizKey;
    }

    public void setBizKey(String bizKey) {
        this.bizKey = bizKey;
    }

    public Long getProcessTime() {
        return this.processTime;
    }

    public void setProcessTime(Long processTime) {
        this.processTime = processTime;
    }

    public Object getBody() {
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public Long getDeliverTime() {
        return this.deliverTime;
    }

    public void setDeliverTime(Long deliverTime) {
        this.deliverTime = deliverTime;
    }

    public String getMsgId() {
        return StringUtils.defaultString((String)this.msgId, (String)this.getHeaderValue("x-data-id"));
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public String getTxId() {
        return this.txId;
    }

    public void setTxId(String txId) {
        this.txId = txId;
    }

    public Integer getPartition() {
        return this.partition;
    }

    public void setPartition(Integer partition) {
        this.partition = partition;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public int getConsumeTimes() {
        return this.consumeTimes;
    }

    public void setConsumeTimes(int consumeTimes) {
        this.consumeTimes = consumeTimes;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public MQMessage addHeader(String name, String value) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{name, value}) || name.startsWith(SKYWALKING_HEADER_PREFIX)) {
            return this;
        }
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
        return this;
    }

    public String getHeaderValue(String name) {
        return this.headers == null ? null : this.headers.get(name);
    }

    public boolean containsHeader(String name) {
        return this.headers == null ? false : this.headers.containsKey(name);
    }

    public void onProducerFinished(String msgId, int partition, long offset) {
        this.msgId = msgId;
        this.partition = partition;
        this.offset = offset;
    }

    public MQMessage initContextHeaders() {
        this.addHeader("x-data-id", String.valueOf(GUID.guid()));
        String headerValue = CurrentRuntimeContext.getRequestId();
        if (headerValue != null) {
            this.addHeader("x-request-id", headerValue);
        }
        if ((headerValue = CurrentRuntimeContext.getTenantId((boolean)false)) != null) {
            this.addHeader("x-tenant-id", headerValue);
        }
        if ((headerValue = CurrentRuntimeContext.getBusinessUnitId()) != null) {
            this.addHeader("x-bunit-id", headerValue);
        }
        if ((headerValue = CurrentRuntimeContext.getCurrentUserId()) != null) {
            this.addHeader("x-user-id", headerValue);
        }
        return this;
    }

    public MQMessage setUserContextOnProduce() {
        this.initContextHeaders();
        return this;
    }

    public MQMessage setUserContextOnConsume() {
        String headerValue = this.getRequestId();
        if (StringUtils.isNotBlank((CharSequence)headerValue)) {
            CurrentRuntimeContext.setRequestId((String)headerValue);
        }
        if (StringUtils.isNotBlank((CharSequence)(headerValue = this.getTenantId()))) {
            CurrentRuntimeContext.setTenantId((String)headerValue);
        }
        if (StringUtils.isNotBlank((CharSequence)(headerValue = this.getBusinessUnitId()))) {
            CurrentRuntimeContext.setBusinessUnitId((String)headerValue);
        }
        if (StringUtils.isNotBlank((CharSequence)(headerValue = this.getProduceBy()))) {
            CurrentRuntimeContext.setAuthUser((AuthUser)new AuthUser(headerValue, null));
        }
        return this;
    }

    public void setTenantId(String tenantId) {
        this.addHeader("x-tenant-id", tenantId);
    }

    public byte[] bodyAsBytes() {
        if (BeanUtils.isSimpleDataType(this.body.getClass())) {
            return this.body.toString().getBytes(StandardCharsets.UTF_8);
        }
        return JsonUtils.toJson((Object)this.body).getBytes(StandardCharsets.UTF_8);
    }

    public String toMessageValue(boolean onlyBody) {
        if (onlyBody) {
            if (BeanUtils.isSimpleDataType(this.body.getClass())) {
                return this.body.toString();
            }
            return JsonUtils.toJson((Object)this.body);
        }
        return JsonUtils.toJson((Object)this);
    }

    public <T> T toObject(Class<T> clazz) {
        return (T)JsonUtils.toObject((String)this.toMessageValue(true), clazz);
    }

    public <T> List<T> toList(Class<T> clazz) {
        return JsonUtils.toList((String)this.toMessageValue(true), clazz);
    }

    public void setOriginMessage(Object originMessage) {
        this.originMessage = originMessage;
    }

    public <T> T getOriginMessage(Class<?> clazz) {
        return (T)this.originMessage;
    }

    public boolean originStatusCompleted(String statusCheckUrl) {
        if (StringUtils.isBlank((CharSequence)statusCheckUrl)) {
            return true;
        }
        HttpResponseEntity resp = HttpRequestEntity.get((String)statusCheckUrl).queryParam("txId", (Object)this.txId).execute();
        boolean completed = false;
        try {
            completed = Boolean.parseBoolean(resp.getUnwrapBody());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return completed;
    }

    public String toString() {
        return "MQMessage [msgId=" + this.getMsgId() + ", topic=" + this.topic + ", bizKey=" + this.bizKey + ", headers=" + this.headers + "]";
    }

    public String logString() {
        return this.toString();
    }
}

