/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.amqp;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.dromara.mendmix.amqp.MQConsumer;
import org.dromara.mendmix.amqp.MQContext;
import org.dromara.mendmix.amqp.MQInstanceDelegate;
import org.dromara.mendmix.amqp.MQProducer;
import org.dromara.mendmix.amqp.MQTopicRef;
import org.dromara.mendmix.amqp.MessageHandler;
import org.dromara.mendmix.amqp.adapter.AbstractProducer;
import org.dromara.mendmix.amqp.adapter.eventbus.EventbusProducerAdapter;
import org.dromara.mendmix.amqp.adapter.jms.JmsConsumerAdapter;
import org.dromara.mendmix.amqp.adapter.jms.JmsProducerAdapter;
import org.dromara.mendmix.amqp.adapter.kafka.KafkaConsumerAdapter;
import org.dromara.mendmix.amqp.adapter.kafka.KafkaProducerAdapter;
import org.dromara.mendmix.amqp.adapter.rabbitmq.RabbitmqConsumerAdapter;
import org.dromara.mendmix.amqp.adapter.rabbitmq.RabbitmqProducerAdapter;
import org.dromara.mendmix.amqp.adapter.redis.RedisConsumerAdapter;
import org.dromara.mendmix.amqp.adapter.redis.RedisProducerAdapter;
import org.dromara.mendmix.amqp.adapter.rocketmq.RocketProducerAdapter;
import org.dromara.mendmix.amqp.adapter.rocketmq.RocketmqConsumerAdapter;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.common.util.SpringAopHelper;
import org.dromara.mendmix.spring.InstanceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.PriorityOrdered;
import org.springframework.data.redis.connection.RedisConnectionFactory;

public class MQServiceRegistryBean
implements InitializingBean,
DisposableBean,
PriorityOrdered {
    protected static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.amqp.adapter");
    private Map<String, MQConsumer> consumers = new HashMap<String, MQConsumer>();
    private Map<String, MQProducer> producers = new HashMap<String, MQProducer>();
    private Map<String, MQContext> contexts = new HashMap<String, MQContext>();
    @Autowired(required=false)
    private RedisConnectionFactory connectionFactory;

    public void afterPropertiesSet() throws Exception {
        Enumeration<Object> keys = ResourceUtils.getAllProperties((String)".*\\.amqp.provider", (boolean)false).keys();
        while (keys.hasMoreElements()) {
            MQConsumer consumer;
            MQProducer producer;
            MQContext context = new MQContext(keys.nextElement().toString().split("\\.")[0]);
            if ("none".equals(context.getProviderName())) continue;
            logger.info(context.toString());
            if (context.isProducerEnabled() && (producer = this.startProducer(context)) != null) {
                this.producers.put(context.getInstance(), producer);
            }
            if (context.isConsumerEnabled() && (consumer = this.startConsumer(context)) != null) {
                this.consumers.put(context.getInstance(), consumer);
            }
            this.contexts.put(context.getInstance(), context);
        }
        MQInstanceDelegate.init(this.contexts, this.producers);
    }

    private MQProducer startProducer(MQContext context) throws Exception {
        String providerName = context.getProviderName();
        AbstractProducer producer = null;
        if ("jms".equals(providerName)) {
            producer = new JmsProducerAdapter(context);
        } else if ("rocketmq".equals(providerName)) {
            producer = new RocketProducerAdapter(context);
        } else if ("kafka".equals(providerName)) {
            producer = new KafkaProducerAdapter(context);
        } else if ("rabbitmq".equals(providerName)) {
            producer = new RabbitmqProducerAdapter(context);
        } else if ("redis".equals(providerName)) {
            producer = new RedisProducerAdapter(context);
        } else if ("eventbus".equals(providerName)) {
            producer = new EventbusProducerAdapter(context);
        } else {
            throw new MendmixBaseException("NOT_SUPPORT[providerName]:" + providerName);
        }
        if (producer != null) {
            producer.start();
        }
        return producer;
    }

    private MQConsumer startConsumer(MQContext context) throws Exception {
        String providerName = context.getProviderName();
        Map messageHanlders = InstanceFactory.getBeansOfType(MessageHandler.class);
        if (messageHanlders == null || messageHanlders.isEmpty()) {
            return null;
        }
        HashMap<String, MessageHandler> messageHandlerMaps = new HashMap<String, MessageHandler>();
        for (MessageHandler handler : messageHanlders.values()) {
            MQTopicRef topicRef;
            Object origin = handler;
            try {
                origin = SpringAopHelper.getTarget((Object)handler);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if ((topicRef = origin.getClass().getAnnotation(MQTopicRef.class)) != null && !StringUtils.equals((CharSequence)context.getInstance(), (CharSequence)topicRef.instance())) continue;
            String topicName = handler.topicName();
            if (StringUtils.isBlank((CharSequence)topicName) && topicRef != null) {
                topicName = topicRef.value();
            }
            Validate.notBlank((CharSequence)topicName, (String)("topic define is null for:" + origin.getClass().getSimpleName()), (Object[])new Object[0]);
            topicName = context.rebuildWithNamespace(topicName);
            messageHandlerMaps.put(topicName, handler);
            logger.info(">> ADD MQ_COMSUMER_HANDLER ->instance:{},topic:{},handlerClass:{} ", new Object[]{context.getInstance(), topicName, handler.getClass().getName()});
        }
        if (messageHandlerMaps.isEmpty()) {
            return null;
        }
        MQConsumer consumer = null;
        if ("jms".equals(providerName)) {
            consumer = new JmsConsumerAdapter(context, messageHandlerMaps);
        } else if ("rocketmq".equals(providerName)) {
            consumer = new RocketmqConsumerAdapter(context, messageHandlerMaps);
        } else if ("eventbus".equals(providerName)) {
            EventbusProducerAdapter.setMessageHandlers(messageHandlerMaps);
        } else if ("rabbitmq".equals(providerName)) {
            consumer = new RabbitmqConsumerAdapter(context, messageHandlerMaps);
        } else if ("kafka".equals(providerName)) {
            consumer = new KafkaConsumerAdapter(context, messageHandlerMaps);
        } else if ("redis".equals(providerName)) {
            consumer = new RedisConsumerAdapter(context, this.connectionFactory, messageHandlerMaps);
        } else {
            throw new MendmixBaseException("NOT_SUPPORT[providerName]:" + providerName);
        }
        if (context.hasInternalTopics()) {
            EventbusProducerAdapter.setMessageHandlers(messageHandlerMaps);
        }
        if (consumer != null) {
            consumer.start();
        }
        logger.info(">> MQ_COMSUMER started -> groupName:{},providerName:{}", (Object)context.getGroupName(), (Object)providerName);
        return consumer;
    }

    public void destroy() throws Exception {
        for (MQProducer producer : this.producers.values()) {
            producer.shutdown();
        }
        for (MQConsumer consumer : this.consumers.values()) {
            consumer.shutdown();
        }
        MQContext.close();
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

