/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.amqp;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.dromara.mendmix.amqp.MQMessage;
import org.dromara.mendmix.common.async.StandardThreadExecutor;
import org.dromara.mendmix.common.util.DateUtils;
import org.dromara.mendmix.spring.InstanceFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcTemplate;

public class MessageStateCheckService
implements InitializingBean,
DisposableBean {
    private static final int INTERVAL = 3600000;
    private static String countSql = "SELECT COUNT(1) FROM transaction_message_log WHERE id = ?";
    private static String insertSql = "INSERT INTO `transaction_message_log` (`id`,`topic`, `msg_id`,`created_at`, `created_by`) VALUES (?,?,?,?,?)";
    private ScheduledExecutorService executor;
    private JdbcTemplate jdbcTemplate;
    private Boolean withLogTable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcTemplate getJdbcTemplate() {
        if (this.jdbcTemplate != null) {
            return this.jdbcTemplate;
        }
        MessageStateCheckService messageStateCheckService = this;
        synchronized (messageStateCheckService) {
            Map beans = InstanceFactory.getBeansOfType(JdbcTemplate.class);
            this.jdbcTemplate = beans.size() == 1 ? (JdbcTemplate)beans.values().stream().findFirst().get() : (JdbcTemplate)beans.get("defaultJdbcTemplate");
        }
        return this.jdbcTemplate;
    }

    public void saveMessageTx(MQMessage message) {
        if (this.getJdbcTemplate() == null || !this.isWithLogTable()) {
            return;
        }
        this.jdbcTemplate.update(insertSql, new Object[]{message.getTxId(), message.getTopic(), message.getMsgId(), new Date(), message.getProduceBy()});
    }

    public boolean checkMessageTx(String txId) {
        if (this.getJdbcTemplate() == null || !this.isWithLogTable()) {
            return true;
        }
        return (Integer)this.jdbcTemplate.queryForObject(countSql, Integer.class, new Object[]{txId}) > 0;
    }

    private boolean isWithLogTable() {
        return this.withLogTable != null && this.withLogTable != false;
    }

    public void afterPropertiesSet() throws Exception {
        this.executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new StandardThreadExecutor.StandardThreadFactory("MessageStateCheckScheduler"));
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                block3: {
                    if (MessageStateCheckService.this.getJdbcTemplate() == null || MessageStateCheckService.this.withLogTable != null && !MessageStateCheckService.this.withLogTable.booleanValue()) {
                        return;
                    }
                    Date dateEnd = DateUtils.addHours((Date)new Date(), (int)-168);
                    try {
                        MessageStateCheckService.this.jdbcTemplate.update("DELETE FROM transaction_message_log WHERE created_at < ?", new Object[]{dateEnd});
                        MessageStateCheckService.this.withLogTable = true;
                    }
                    catch (Exception e) {
                        if (!(e instanceof BadSqlGrammarException)) break block3;
                        MessageStateCheckService.this.withLogTable = false;
                    }
                }
            }
        }, 1000L, 3600000L, TimeUnit.MILLISECONDS);
    }

    public void destroy() throws Exception {
        this.executor.shutdown();
    }
}

