/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.amqp.adapter;

import org.dromara.mendmix.amqp.MQContext;
import org.dromara.mendmix.amqp.MQMessage;
import org.dromara.mendmix.amqp.MQProducer;
import org.dromara.mendmix.amqp.MessageStateCheckService;
import org.dromara.mendmix.amqp.adapter.eventbus.EventbusProducerAdapter;
import org.dromara.mendmix.common.guid.GUID;
import org.dromara.mendmix.spring.InstanceFactory;

public abstract class AbstractProducer
implements MQProducer {
    protected MQContext context;
    private MessageStateCheckService messageStateCheckService;
    private static MQProducer internalMQProducer;

    public AbstractProducer(MQContext context) {
        this.context = context;
    }

    @Override
    public void start() throws Exception {
        this.messageStateCheckService = (MessageStateCheckService)InstanceFactory.getInstance(MessageStateCheckService.class);
        if (this.context.hasInternalTopics()) {
            internalMQProducer = new EventbusProducerAdapter(this.context);
            internalMQProducer.start();
        }
    }

    public MessageStateCheckService messageStateCheckService() {
        if (this.messageStateCheckService != null) {
            return this.messageStateCheckService;
        }
        this.messageStateCheckService = (MessageStateCheckService)InstanceFactory.getInstance(MessageStateCheckService.class);
        return this.messageStateCheckService;
    }

    public static MQProducer getInternalMQProducer() {
        return internalMQProducer;
    }

    @Override
    public void shutdown() {
        if (internalMQProducer != null) {
            internalMQProducer.shutdown();
        }
    }

    public void handleSuccess(MQMessage message) {
        MQContext.processMessageLog(this.context, message, MQContext.ActionType.pub, null);
    }

    public void handleError(MQMessage message, Throwable e) {
        MQContext.processMessageLog(this.context, message, MQContext.ActionType.pub, e);
    }

    public void prepareHandle(MQMessage message) {
        message.initContextHeaders();
    }

    @Override
    public String sendTxMessage(MQMessage message) {
        message.setTxId(String.valueOf(GUID.guid()));
        String msgId = this.sendMessage(message, false);
        this.messageStateCheckService().saveMessageTx(message);
        return msgId;
    }
}

