/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.amqp.adapter.aliyun.mns;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.client.CloudTopic;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.common.ServiceException;
import com.aliyun.mns.model.PagingListResult;
import com.aliyun.mns.model.QueueMeta;
import com.aliyun.mns.model.SubscriptionMeta;
import com.aliyun.mns.model.TopicMeta;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.util.ResourceUtils;

public class MNSClientInstance {
    private static MNSClient client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MNSClient getClient() {
        if (client != null) {
            return client;
        }
        Class<MNSClientInstance> clazz = MNSClientInstance.class;
        synchronized (MNSClientInstance.class) {
            if (client != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return client;
            }
            String accessKeyId = ResourceUtils.getAndValidateProperty((String)"aliyun.mns.accessKeyId");
            String accessKeySecret = ResourceUtils.getAndValidateProperty((String)"aliyun.mns.accessKeySecret");
            String endpoint = ResourceUtils.getAndValidateProperty((String)"aliyun.mns.endpoint");
            CloudAccount account = new CloudAccount(accessKeyId, accessKeySecret, endpoint);
            client = account.getMNSClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return client;
        }
    }

    public static CloudQueue createQueueIfAbsent(String queueName) {
        QueueMeta queueMeta = new QueueMeta();
        queueMeta.setQueueName(queueName);
        CloudQueue queue = MNSClientInstance.getClient().getQueueRef(queueName);
        if (!queue.isQueueExist()) {
            queue.create(queueMeta);
        }
        return queue;
    }

    public static CloudTopic createTopicIfAbsent(String topicName, String subForQueue) {
        String subscriptionName;
        PagingListResult topicSubscriptions;
        CloudTopic topic;
        block3: {
            TopicMeta topicMeta = new TopicMeta();
            topicMeta.setTopicName(topicName);
            topic = MNSClientInstance.getClient().getTopicRef(topicName);
            try {
                topic.getAttribute();
            }
            catch (ServiceException e) {
                if (!"TopicNotExist".equals(e.getErrorCode())) break block3;
                topic.create(topicMeta);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)subForQueue) && ((topicSubscriptions = topic.listSubscriptions(subscriptionName = "sub-for-queue-" + subForQueue, "", Integer.valueOf(1))) == null || topicSubscriptions.getResult() == null || topicSubscriptions.getResult().isEmpty())) {
            SubscriptionMeta subMeta = new SubscriptionMeta();
            subMeta.setSubscriptionName(subscriptionName);
            subMeta.setEndpoint(topic.generateQueueEndpoint(subForQueue));
            subMeta.setNotifyContentFormat(SubscriptionMeta.NotifyContentFormat.SIMPLIFIED);
            subMeta.setNotifyStrategy(SubscriptionMeta.NotifyStrategy.EXPONENTIAL_DECAY_RETRY);
            topic.subscribe(subMeta);
        }
        return topic;
    }
}

