/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.amqp.adapter.aliyun.mns;

import com.aliyun.mns.client.CloudTopic;
import com.aliyun.mns.model.RawTopicMessage;
import com.aliyun.mns.model.TopicMessage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dromara.mendmix.amqp.MQMessage;
import org.dromara.mendmix.amqp.adapter.aliyun.mns.MNSClientInstance;

public class MNSProducer {
    private Map<String, CloudTopic> topics = new ConcurrentHashMap<String, CloudTopic>();

    public String publishMessage(String topicName, Object data) {
        CloudTopic topic = this.getTopic(topicName);
        RawTopicMessage tMessage = new RawTopicMessage();
        tMessage.setBaseMessageBody(new MQMessage(topicName, data).toMessageValue(false));
        topic.publishMessage((TopicMessage)tMessage);
        return tMessage.getMessageId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloudTopic getTopic(String topicName) {
        if (!this.topics.containsKey(topicName)) {
            MNSProducer mNSProducer = this;
            synchronized (mNSProducer) {
                if (!this.topics.containsKey(topicName)) {
                    CloudTopic topic = MNSClientInstance.createTopicIfAbsent(topicName, null);
                    this.topics.put(topicName, topic);
                }
            }
        }
        return this.topics.get(topicName);
    }
}

