/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.amqp.adapter.jms;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.dromara.mendmix.amqp.MQConsumer;
import org.dromara.mendmix.amqp.MQContext;
import org.dromara.mendmix.amqp.MQMessage;
import org.dromara.mendmix.amqp.MessageHandler;
import org.dromara.mendmix.amqp.adapter.jms.JmsResourceManager;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsConsumerAdapter
implements MQConsumer {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.amqp.adapter");
    private MQContext context;
    private Map<String, MessageHandler> messageHandlers = new HashMap<String, MessageHandler>();
    private Session session;
    private List<MessageConsumer> consumers = new ArrayList<MessageConsumer>();

    public JmsConsumerAdapter(MQContext context, Map<String, MessageHandler> messageHandlers) {
        this.context = context;
        this.messageHandlers = messageHandlers;
    }

    @Override
    public void start() throws Exception {
        this.session = JmsResourceManager.createSession(this.context);
        Set<String> topicNames = this.messageHandlers.keySet();
        for (String topicName : topicNames) {
            Topic jmsTopic = this.session.createTopic(topicName);
            MessageConsumer consumer = this.session.createConsumer((Destination)jmsTopic);
            consumer.setMessageListener(message -> {
                MQMessage _message = null;
                try {
                    _message = new MQMessage(topicName, ((TextMessage)message).getText());
                    _message.setMsgId(message.getJMSMessageID());
                    Enumeration propertyNames = message.getPropertyNames();
                    while (propertyNames.hasMoreElements()) {
                        String headerName = Objects.toString(propertyNames.nextElement(), null);
                        if (!message.propertyExists(headerName)) continue;
                        _message.addHeader(headerName, message.getStringProperty(headerName));
                    }
                    _message.setUserContextOnConsume();
                    this.messageHandlers.get(topicName).process(_message);
                    message.acknowledge();
                    if (logger.isDebugEnabled()) {
                        logger.debug("MQ_MESSAGE_CONSUME_SUCCESS ->message:{}", (Object)message);
                    }
                    MQContext.processMessageLog(this.context, _message, MQContext.ActionType.sub, null);
                }
                catch (Exception e) {
                    logger.error(String.format("MQ_MESSAGE_CONSUME_ERROR ->message:%s", message.toString()), (Throwable)e);
                    if (_message != null) {
                        MQContext.processMessageLog(this.context, _message, MQContext.ActionType.sub, e);
                    }
                }
                finally {
                    ThreadLocalContext.unset();
                }
            });
            this.consumers.add(consumer);
        }
    }

    @Override
    public void shutdown() {
        for (MessageConsumer consumer : this.consumers) {
            try {
                consumer.close();
            }
            catch (Exception exception) {}
        }
        try {
            this.session.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }
}

