/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.amqp.adapter.jms;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.dromara.mendmix.amqp.MQContext;
import org.dromara.mendmix.amqp.MQMessage;
import org.dromara.mendmix.amqp.adapter.AbstractProducer;
import org.dromara.mendmix.amqp.adapter.jms.JmsResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsProducerAdapter
extends AbstractProducer {
    private final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.amqp.adapter");
    private Session session;
    private Map<String, MessageProducer> topicProducerMappings = new ConcurrentHashMap<String, MessageProducer>();

    public JmsProducerAdapter(MQContext context) {
        super(context);
        this.session = JmsResourceManager.createSession(context);
    }

    @Override
    public String sendMessage(MQMessage message, boolean async) {
        this.prepareHandle(message);
        try {
            TextMessage textMessage = this.session.createTextMessage(message.toMessageValue(true));
            if (message.getHeaders() != null) {
                for (String name : message.getHeaders().keySet()) {
                    String headerValue = message.getHeaders().get(name);
                    if (headerValue == null) continue;
                    textMessage.setStringProperty(name, headerValue);
                }
            }
            this.getMessageProducer(message.getTopic()).send((Message)textMessage);
            this.handleSuccess(message);
            this.logger.debug("\u53d1\u9001\u6210\u529f, topic:{}", (Object)message.getTopic());
            return textMessage.getJMSMessageID();
        }
        catch (Exception e) {
            this.handleError(message, e);
            this.logger.warn("\u53d1\u9001\u5931\u8d25, topic:{}, exception:{}", (Object)message.getTopic(), (Object)e);
            return null;
        }
    }

    private MessageProducer getMessageProducer(String topic) {
        if (this.topicProducerMappings.containsKey(topic)) {
            return this.topicProducerMappings.get(topic);
        }
        Map<String, MessageProducer> map = this.topicProducerMappings;
        synchronized (map) {
            try {
                Topic jmsTopic = this.session.createTopic(topic);
                MessageProducer producer = this.session.createProducer((Destination)jmsTopic);
                this.topicProducerMappings.put(topic, producer);
                return producer;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.topicProducerMappings.values().forEach(o -> {
            try {
                o.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        try {
            this.session.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }
}

