/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.amqp.adapter.jms;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.Objects;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.dromara.mendmix.amqp.MQContext;
import org.dromara.mendmix.common.GlobalContext;

public class JmsResourceManager {
    private static volatile Connection connection;
    private static volatile Session session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(MQContext context) {
        if (connection != null) {
            return connection;
        }
        Class<JmsResourceManager> clazz = JmsResourceManager.class;
        synchronized (JmsResourceManager.class) {
            if (connection != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return connection;
            }
            Properties properties = context.getProfileProperties();
            String targetConnectionFactoryClass = Objects.toString(properties.remove("targetConnectionFactoryClass"));
            try {
                Field[] fields;
                Class<?> clazz2 = Class.forName(targetConnectionFactoryClass);
                ConnectionFactory connectionFactory = (ConnectionFactory)clazz2.newInstance();
                for (Field field : fields = FieldUtils.getAllFields(clazz2)) {
                    field.setAccessible(true);
                    String configKey = field.getName();
                    Object configValue = null;
                    if (!properties.containsKey(configKey)) continue;
                    configValue = field.getType() == Integer.TYPE || field.getType() == Integer.class ? Integer.valueOf(Integer.parseInt(properties.getProperty(configKey))) : (field.getType() == Long.TYPE || field.getType() == Long.class ? Long.valueOf(Long.parseLong(properties.getProperty(configKey))) : (field.getType() == Double.TYPE || field.getType() == Double.class ? Double.valueOf(Double.parseDouble(properties.getProperty(configKey))) : (field.getType() == Boolean.TYPE || field.getType() == Boolean.class ? Boolean.valueOf(Boolean.parseBoolean(properties.getProperty(configKey))) : (field.getType() == URI.class ? URI.create(properties.getProperty(configKey)) : properties.getProperty(configKey)))));
                    field.set(connectionFactory, configValue);
                }
                connection = connectionFactory.createConnection();
                connection.setClientID(context.getGroupName() + GlobalContext.getWorkerId());
                connection.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session getSession(MQContext context) {
        if (session != null) {
            return session;
        }
        Class<JmsResourceManager> clazz = JmsResourceManager.class;
        synchronized (JmsResourceManager.class) {
            if (session != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return session;
            }
            try {
                session = JmsResourceManager.getConnection(context).createSession(false, 2);
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
            return session;
        }
    }

    public static Session createSession(MQContext context) {
        try {
            return JmsResourceManager.getConnection(context).createSession(false, 1);
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    public static void close() {
        if (session != null) {
            try {
                session.close();
                session = null;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

