/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.amqp.adapter.qcloud.cmq;

import com.qcloud.cmq.CMQServerException;
import com.qcloud.cmq.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.dromara.mendmix.amqp.MQContext;
import org.dromara.mendmix.amqp.MQMessage;
import org.dromara.mendmix.amqp.MessageHandler;
import org.dromara.mendmix.amqp.adapter.AbstractConsumer;
import org.dromara.mendmix.amqp.adapter.qcloud.cmq.CMQManager;

public class CMQConsumerAdapter
extends AbstractConsumer {
    public CMQConsumerAdapter(MQContext context, Map<String, MessageHandler> messageHandlers) {
        super(context, messageHandlers);
        CMQManager.doInit(context);
    }

    @Override
    public void start() throws Exception {
        Set topicNames = this.messageHandlers.keySet();
        for (String topic : topicNames) {
            CMQManager.createSubscriptionIfAbsent(topic);
        }
        super.startWorker();
    }

    @Override
    public List<MQMessage> fetchMessages() {
        try {
            List messages;
            try {
                messages = CMQManager.getQueue().batchReceiveMessage(this.context.getBatchSize());
            }
            catch (CMQServerException e) {
                if (e.getMessage().equals("(10200)no message")) {
                    return null;
                }
                throw e;
            }
            if (messages == null || messages.isEmpty()) {
                return new ArrayList<MQMessage>(0);
            }
            return messages.stream().map(o -> {
                MQMessage message = MQMessage.build(o.msgBody);
                message.setOriginMessage(o);
                return message;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("MENDMIX-TRACE-LOGGGING-->> ", (Throwable)e);
            return new ArrayList<MQMessage>(0);
        }
    }

    @Override
    public String handleMessageConsumed(MQMessage message, boolean successed) {
        try {
            Message originMessage = (Message)message.getOriginMessage(Message.class);
            String receiptHandle = originMessage.receiptHandle;
            CMQManager.getQueue().deleteMessage(receiptHandle);
        }
        catch (Exception e) {
            logger.error("MENDMIX-TRACE-LOGGGING-->> ", (Throwable)e);
        }
        return null;
    }
}

