/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.amqp.adapter.qcloud.cmq;

import com.qcloud.cmq.Account;
import com.qcloud.cmq.Queue;
import com.qcloud.cmq.QueueMeta;
import com.qcloud.cmq.Subscription;
import com.qcloud.cmq.Topic;
import com.qcloud.cmq.entity.CmqConfig;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.Validate;
import org.dromara.mendmix.amqp.MQContext;
import org.dromara.mendmix.common.util.JsonUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMQManager {
    private static Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.amqp.adapter");
    private Account account;
    private String queueName;
    private volatile Queue queue;
    private Map<String, Topic> topicMappings = new ConcurrentHashMap<String, Topic>();
    private static CMQManager instance = new CMQManager();

    private CMQManager() {
    }

    public static void doInit(MQContext context) {
        if (CMQManager.instance.account != null) {
            return;
        }
        CMQManager.instance.queueName = context.getGroupName();
        CmqConfig config = (CmqConfig)ResourceUtils.getBean((String)"mendmix-cloud.amqp.cmq.", CmqConfig.class);
        Validate.notBlank((CharSequence)config.getEndpoint(), (String)"config[mq.cmq.endpoint] not found", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)config.getSecretId(), (String)"config[mq.cmq.secretId] not found", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)config.getSecretKey(), (String)"config[mq.cmq.secretKey] not found", (Object[])new Object[0]);
        config.setAlwaysPrintResultLog(false);
        config.setPrintSlow(false);
        CMQManager.instance.account = new Account(config);
        logger.info("MENDMIX-TRACE-LOGGGING-->> init CMQ Account OK -> endpoint:{}", (Object)config.getEndpoint());
    }

    public static Account getAccount() {
        return CMQManager.instance.account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Queue getQueue() {
        if (CMQManager.instance.queue != null) {
            return CMQManager.instance.queue;
        }
        CMQManager cMQManager = instance;
        synchronized (cMQManager) {
            if (CMQManager.instance.queue != null) {
                return CMQManager.instance.queue;
            }
            CMQManager.instance.queue = instance.createQueueIfAbsent();
        }
        return CMQManager.instance.queue;
    }

    private Queue createQueueIfAbsent() {
        Queue queue = this.account.getQueue(this.queueName);
        try {
            ArrayList existList = new ArrayList(1);
            this.account.listQueue(this.queueName, -1, -1, existList);
            if (!existList.contains(this.queueName)) {
                queue = this.createQueue(this.queueName);
            }
            QueueMeta meta = queue.getQueueAttributes();
            System.out.println(">>QueueMeta:" + JsonUtils.toJson((Object)meta));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return queue;
    }

    public static Topic createTopicIfAbsent(String topicName) {
        if (CMQManager.instance.topicMappings.containsKey(topicName)) {
            return CMQManager.instance.topicMappings.get(topicName);
        }
        Topic topic = CMQManager.getAccount().getTopic(topicName);
        try {
            ArrayList existList = new ArrayList(1);
            CMQManager.getAccount().listTopic(topicName, existList, -1, -1);
            if (!existList.contains(topicName)) {
                CMQManager.createTopic(topicName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        CMQManager.instance.topicMappings.put(topicName, topic);
        return topic;
    }

    public static Subscription createSubscriptionIfAbsent(String topicName) {
        if (CMQManager.instance.queue == null) {
            CMQManager.getQueue();
        }
        Topic topic = CMQManager.createTopicIfAbsent(topicName);
        String subscriptionName = CMQManager.buildSubscriptionName(topicName, CMQManager.instance.queueName);
        Subscription subscription = CMQManager.getAccount().getSubscription(topicName, subscriptionName);
        try {
            ArrayList existList = new ArrayList(1);
            topic.ListSubscription(-1, -1, subscriptionName, existList);
            if (!existList.contains(subscriptionName)) {
                CMQManager.createSubscription(topicName, CMQManager.instance.queueName, subscriptionName);
            }
            logger.info("MENDMIX-TRACE-LOGGGING-->> subscriptionName:{} for queue:{},topic:{}", new Object[]{subscriptionName, CMQManager.instance.queueName, topicName});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return subscription;
    }

    private static String buildSubscriptionName(String topicName, String queueName) {
        return String.format("sub-for_%s-%s", queueName, topicName);
    }

    private Queue createQueue(String queueName) {
        try {
            QueueMeta meta = (QueueMeta)ResourceUtils.getBean((String)"mendmix-cloud.amqp.cmq.", QueueMeta.class);
            this.account.createQueue(queueName, meta);
            logger.info("MENDMIX-TRACE-LOGGGING-->> createQueue finished -> queueName:{}", (Object)queueName);
        }
        catch (Exception e) {
            if (!e.getMessage().contains("is already existed")) {
                throw new RuntimeException(e);
            }
            logger.info("MENDMIX-TRACE-LOGGGING-->> queueName:{} is already existed", (Object)queueName);
        }
        return this.account.getQueue(queueName);
    }

    private static void createTopic(String topicName) {
        try {
            logger.info("MENDMIX-TRACE-LOGGGING-->> createTopic begin -> topicName:", (Object)topicName);
            int maxMsgSize = 0x100000;
            CMQManager.getAccount().createTopic(topicName, maxMsgSize);
            logger.info("MENDMIX-TRACE-LOGGGING-->> createTopic finished -> topicName:{}", (Object)topicName);
        }
        catch (Exception e) {
            if (!e.getMessage().contains("is already existed")) {
                throw new RuntimeException(e);
            }
            logger.info("MENDMIX-TRACE-LOGGGING-->> topicName:{} is already existed", (Object)topicName);
        }
    }

    private static void createSubscription(String topicName, String queueName, String subscriptionName) {
        try {
            CMQManager.getAccount().createSubscribe(topicName, subscriptionName, queueName, "queue");
            logger.info("MENDMIX-TRACE-LOGGGING-->> createSubscription finished -> subscriptionName:{}", (Object)subscriptionName);
        }
        catch (Exception e) {
            if (!e.getMessage().contains("is already existed")) {
                throw new RuntimeException(e);
            }
            logger.info("MENDMIX-TRACE-LOGGGING-->> subscriptionName:{} is already existed", (Object)subscriptionName);
        }
    }
}

