/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.amqp.adapter.qcloud.cmq;

import com.qcloud.cmq.Topic;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.amqp.MQContext;
import org.dromara.mendmix.amqp.MQMessage;
import org.dromara.mendmix.amqp.adapter.AbstractProducer;
import org.dromara.mendmix.amqp.adapter.qcloud.cmq.CMQManager;

public class CMQProducerAdapter
extends AbstractProducer {
    public CMQProducerAdapter(MQContext context) {
        super(context);
        CMQManager.doInit(context);
    }

    @Override
    public String sendMessage(MQMessage message, boolean async) {
        try {
            Topic topic = CMQManager.createTopicIfAbsent(message.getTopic());
            String msgId = StringUtils.replace((String)UUID.randomUUID().toString(), (String)"-", (String)"");
            message.setMsgId(msgId);
            topic.publishMessage(message.toMessageValue(false));
            this.handleSuccess(message);
            return msgId;
        }
        catch (Exception e) {
            this.handleError(message, e);
            throw new RuntimeException("cmq_error", e);
        }
    }
}

