/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.amqp.adapter.rabbitmq;

import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.dromara.mendmix.amqp.MQContext;
import org.dromara.mendmix.common.util.ResourceUtils;

public class CachingChannelFactory {
    private static String exchangeName;
    private static Channel produceChannel;
    private static List<Channel> channelHub;

    public static String getExchangeName() {
        return exchangeName;
    }

    public static ConnectionFactory buildConnectionFactory(MQContext context) {
        Map rabbitmqProperties = ResourceUtils.getMappingValues((String)(context.getInstance() + ".amqp.rabbitmq"));
        exchangeName = (String)rabbitmqProperties.get("exchangeName");
        ConnectionFactory factory = new ConnectionFactory();
        factory.setHost((String)rabbitmqProperties.get("host"));
        factory.setPort(Integer.parseInt((String)rabbitmqProperties.get("port")));
        factory.setUsername((String)rabbitmqProperties.get("username"));
        factory.setPassword((String)rabbitmqProperties.get("password"));
        factory.setVirtualHost((String)rabbitmqProperties.get("virtualHost"));
        if (rabbitmqProperties.containsKey("connectionTimeout")) {
            factory.setConnectionTimeout(Integer.parseInt((String)rabbitmqProperties.get("connectionTimeout")));
        }
        Validate.notBlank((CharSequence)factory.getHost(), (String)"[host] is missing", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)factory.getVirtualHost(), (String)"[virtualHost] is missing", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)exchangeName)) {
            exchangeName = "exchange" + StringUtils.replace((String)factory.getVirtualHost(), (String)"/", (String)"-");
        }
        Validate.notBlank((CharSequence)exchangeName, (String)"[exchangeName] is missing", (Object[])new Object[0]);
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Channel getProduceChannel(MQContext context) {
        if (produceChannel != null && produceChannel.isOpen()) {
            return produceChannel;
        }
        try {
            Class<CachingChannelFactory> clazz = CachingChannelFactory.class;
            synchronized (CachingChannelFactory.class) {
                if (produceChannel != null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return produceChannel;
                }
                produceChannel = CachingChannelFactory.createChannel(context);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return produceChannel;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Channel createChannel(MQContext context) {
        try {
            Class<CachingChannelFactory> clazz = CachingChannelFactory.class;
            synchronized (CachingChannelFactory.class) {
                ConnectionFactory connectionFactory = CachingChannelFactory.buildConnectionFactory(context);
                Connection connection = connectionFactory.newConnection();
                Channel channel = connection.createChannel();
                channel.exchangeDeclare(exchangeName, BuiltinExchangeType.TOPIC, false);
                channelHub.add(channel);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return channel;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void closeAll() {
        for (Channel channel : channelHub) {
            try {
                channel.close();
            }
            catch (Exception exception) {}
        }
    }

    static {
        channelHub = new ArrayList<Channel>();
    }
}

