/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.amqp.adapter.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.MessageProperties;
import java.util.HashMap;
import org.dromara.mendmix.amqp.MQContext;
import org.dromara.mendmix.amqp.MQMessage;
import org.dromara.mendmix.amqp.adapter.AbstractProducer;
import org.dromara.mendmix.amqp.adapter.rabbitmq.CachingChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitmqProducerAdapter
extends AbstractProducer {
    private final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.amqp.adapter");

    public RabbitmqProducerAdapter(MQContext context) {
        super(context);
    }

    @Override
    public String sendMessage(MQMessage message, boolean async) {
        this.prepareHandle(message);
        Channel channel = CachingChannelFactory.getProduceChannel(this.context);
        String exchangeName = CachingChannelFactory.getExchangeName();
        AMQP.BasicProperties props = this.buildMessageBasicProperties(message);
        byte[] data = message.bodyAsBytes();
        try {
            channel.basicPublish(exchangeName, message.getTopic(), props, data);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("MQ_SEND_SUCCESS:{} -> msgId:{},status:{}", (Object)message.getTopic(), (Object)message.getMsgId());
            }
            message.onProducerFinished(message.getMsgId(), 0, 0L);
            this.handleSuccess(message);
        }
        catch (Exception e) {
            this.handleError(message, e);
            this.logger.warn("MQ_SEND_FAIL:" + message.getTopic(), (Throwable)e);
        }
        return null;
    }

    private AMQP.BasicProperties buildMessageBasicProperties(MQMessage message) {
        AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties.Builder();
        builder.deliveryMode(MessageProperties.PERSISTENT_TEXT_PLAIN.getDeliveryMode());
        builder.priority(MessageProperties.PERSISTENT_TEXT_PLAIN.getPriority());
        builder.messageId(message.getMsgId());
        HashMap<String, String> headers = new HashMap<String, String>();
        if (message.getHeaders() != null) {
            for (String name : message.getHeaders().keySet()) {
                String headerValue = message.getHeaders().get(name);
                if (headerValue == null) continue;
                headers.put(name, headerValue);
            }
        }
        builder.headers(headers);
        return builder.build();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        CachingChannelFactory.closeAll();
    }
}

