/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.amqp.adapter.redis;

import org.dromara.mendmix.amqp.MQContext;
import org.dromara.mendmix.amqp.MQMessage;
import org.dromara.mendmix.amqp.MessageHandler;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandlerDelegate {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.amqp.adapter");
    private MQContext context;
    private MessageHandler messageHandler;

    public MessageHandlerDelegate(MQContext context, String topic, MessageHandler messageHandler) {
        this.context = context;
        this.messageHandler = messageHandler;
    }

    public void onMessage(String body, String topic) {
        MQMessage message = MQMessage.build(body);
        try {
            if (message.getTenantId() != null) {
                CurrentRuntimeContext.setTenantId((String)message.getTenantId());
            }
            this.messageHandler.process(message);
            if (logger.isDebugEnabled()) {
                logger.debug("MQ_MESSAGE_CONSUME_SUCCESS ->message:{}", (Object)message.toString());
            }
            MQContext.processMessageLog(this.context, message, MQContext.ActionType.sub, null);
        }
        catch (Exception e) {
            MQContext.processMessageLog(this.context, message, MQContext.ActionType.sub, e);
            logger.error(String.format("MQ_MESSAGE_CONSUME_ERROR ->message:%s", body), (Throwable)e);
        }
    }
}

