/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.amqp.adapter.redis;

import org.dromara.mendmix.amqp.MQContext;
import org.dromara.mendmix.amqp.MQMessage;
import org.dromara.mendmix.amqp.adapter.AbstractProducer;
import org.dromara.mendmix.cache.RedisTemplateGroups;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisProducerAdapter
extends AbstractProducer {
    private final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.amqp.adapter");
    private StringRedisTemplate redisTemplate;

    public RedisProducerAdapter(MQContext context) {
        super(context);
    }

    @Override
    public void start() throws Exception {
        super.start();
    }

    @Override
    public String sendMessage(MQMessage message, boolean async) {
        this.prepareHandle(message);
        try {
            if (this.redisTemplate == null) {
                this.redisTemplate = RedisTemplateGroups.getDefaultStringRedisTemplate();
            }
            this.redisTemplate.convertAndSend(message.getTopic(), (Object)message.toMessageValue(false));
            this.handleSuccess(message);
        }
        catch (Exception e) {
            this.handleError(message, e);
            throw e;
        }
        return null;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

