/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.amqp.adapter.rocketmq;

import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.dromara.mendmix.amqp.MQContext;
import org.dromara.mendmix.amqp.MQMessage;
import org.dromara.mendmix.amqp.adapter.AbstractProducer;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketProducerAdapter
extends AbstractProducer {
    private final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.amqp.adapter");
    private String namesrvAddr;
    private DefaultMQProducer producer;

    public RocketProducerAdapter(MQContext context) {
        super(context);
        this.namesrvAddr = ResourceUtils.getAndValidateProperty((String)(context.getInstance() + ".amqp.rocketmq[namesrvAddr]"));
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.producer = new DefaultMQProducer(this.context.getGroupName());
        this.producer.setNamesrvAddr(this.namesrvAddr);
        this.producer.start();
    }

    @Override
    public String sendMessage(final MQMessage message, boolean async) {
        this.prepareHandle(message);
        Message _message = new Message(message.getTopic(), message.getTag(), message.getBizKey(), message.bodyAsBytes());
        if (message.getHeaders() != null) {
            for (String name : message.getHeaders().keySet()) {
                String headerValue = message.getHeaders().get(name);
                if (headerValue == null) continue;
                _message.putUserProperty(name, headerValue);
            }
        }
        try {
            if (async) {
                this.producer.send(_message, new SendCallback(){

                    public void onSuccess(SendResult sendResult) {
                        if (RocketProducerAdapter.this.logger.isDebugEnabled()) {
                            RocketProducerAdapter.this.logger.debug("MQ_SEND_SUCCESS:{} -> msgId:{},status:{},offset:{}", new Object[]{message.getTopic(), sendResult.getMsgId(), sendResult.getSendStatus().name(), sendResult.getQueueOffset()});
                        }
                        message.onProducerFinished(sendResult.getMsgId(), 0, sendResult.getQueueOffset());
                        RocketProducerAdapter.this.handleSuccess(message);
                    }

                    public void onException(Throwable e) {
                        RocketProducerAdapter.this.handleError(message, e);
                        RocketProducerAdapter.this.logger.warn("MQ_SEND_FAIL:" + message.getTopic(), e);
                    }
                });
            } else {
                SendResult sendResult = this.producer.send(_message);
                message.onProducerFinished(sendResult.getMsgId(), 0, sendResult.getQueueOffset());
                if (sendResult.getSendStatus() == SendStatus.SEND_OK) {
                    this.handleSuccess(message);
                } else {
                    this.handleError(message, (Throwable)new MQClientException(0, sendResult.getSendStatus().name()));
                }
            }
        }
        catch (Exception e) {
            this.handleError(message, e);
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.producer.shutdown();
    }
}

