/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.exception.UnauthorizedException;
import org.dromara.mendmix.common.guid.GUID;
import org.dromara.mendmix.common.model.AuthUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentRuntimeContext {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix");
    private static final String CURRENT_USER_KEY = "_ctx_currentUser_";
    private static final String CURRENT_TENANT_DS_KEY = "_ctx_currentTenantDsKey_";
    private static List<String> contextHeaders = Arrays.asList("x-invoke-token", "x-auth-user", "x-user-id", "x-tenant-id", "x-system-id", "x-client-type", "x-invoker-appid", "x-request-id", "x-trace-logging", "Accept-Language");

    public static void addContextHeaders(Map<String, String> headers) {
        for (String headerName : contextHeaders) {
            String headerVal;
            if (!headers.containsKey(headerName) || (headerVal = headers.get(headerName)) == null) continue;
            if ("x-auth-user".equals(headerName)) {
                AuthUser user = AuthUser.decode(headerVal);
                if (user == null) continue;
                ThreadLocalContext.set("x-auth-user", user);
                continue;
            }
            CurrentRuntimeContext.setContextVal(headerName, headerVal);
        }
    }

    public static void addContextHeader(String name, String value) {
        if ("x-auth-user".equals(name)) {
            AuthUser user = AuthUser.decode(value);
            if (user != null) {
                ThreadLocalContext.set("x-auth-user", user);
            }
        } else if (contextHeaders.contains(name)) {
            CurrentRuntimeContext.setContextVal(name, value);
        }
    }

    public static Map<String, Object> getAllContextVals() {
        AuthUser currentUser;
        HashMap<String, Object> map = new HashMap<String, Object>(contextHeaders.size());
        for (String key : contextHeaders) {
            Object value;
            if ("x-auth-user".equals(key)) continue;
            if (ThreadLocalContext.exists(key)) {
                value = ThreadLocalContext.get(key);
                if (value == null) continue;
                map.put(key, value);
                continue;
            }
            value = CurrentRuntimeContext.getContextVal(key, false);
            if (value == null || StringUtils.isBlank((CharSequence)value.toString())) continue;
            map.put(key, value);
        }
        if (!map.containsKey(CURRENT_USER_KEY) && (currentUser = CurrentRuntimeContext.getCurrentUser()) != null) {
            map.put(CURRENT_USER_KEY, currentUser);
        }
        if ("-1".equals(map.get("x-tenant-id"))) {
            map.remove("x-tenant-id");
        }
        return map;
    }

    public static Map<String, String> getContextHeaders() {
        HashMap<String, String> map = new HashMap<String, String>(contextHeaders.size());
        for (String headerName : contextHeaders) {
            String headerVal = "x-auth-user".equals(headerName) && ThreadLocalContext.exists(headerName) ? CurrentRuntimeContext.getCurrentUser().toEncodeString() : CurrentRuntimeContext.getContextVal(headerName, false);
            if (headerVal == null) continue;
            map.put(headerName, headerVal);
        }
        if (!map.containsKey("x-request-id")) {
            map.put("x-request-id", GUID.uuid());
        }
        return map;
    }

    public static boolean isTraceLogging() {
        return Boolean.parseBoolean(CurrentRuntimeContext.getContextVal("x-trace-logging", false));
    }

    public static void setTenantId(String tenantId) {
        CurrentRuntimeContext.setContextVal("x-tenant-id", tenantId);
    }

    public static String getCurrentUserId() {
        AuthUser currentUser = CurrentRuntimeContext.getCurrentUser();
        return currentUser == null ? null : StringUtils.defaultString((String)currentUser.getId(), (String)currentUser.getName());
    }

    public static AuthUser getCurrentUser() {
        AuthUser user = (AuthUser)ThreadLocalContext.get("x-auth-user");
        return user;
    }

    public static void setAuthUser(AuthUser user) {
        if (user == null) {
            return;
        }
        ThreadLocalContext.set("x-auth-user", user);
    }

    public static AuthUser getAndValidateCurrentUser() {
        AuthUser user = CurrentRuntimeContext.getCurrentUser();
        if (user == null) {
            throw new UnauthorizedException();
        }
        return user;
    }

    public static String getInvokeAppId() {
        return CurrentRuntimeContext.getContextVal("x-invoker-appid", false);
    }

    public static void setRequestId(String requestId) {
        CurrentRuntimeContext.setContextVal("x-request-id", requestId);
    }

    public static String getRequestId() {
        return CurrentRuntimeContext.getContextVal("x-request-id", false);
    }

    public static String getTenantId() {
        return CurrentRuntimeContext.getContextVal("x-tenant-id", false);
    }

    public static String getTenantId(boolean validate) {
        return CurrentRuntimeContext.getContextVal("x-tenant-id", validate);
    }

    public static void setBusinessUnitId(String businessUnitId) {
        CurrentRuntimeContext.setContextVal("x-bunit-id", businessUnitId);
    }

    public static String getBusinessUnitId() {
        String buId = CurrentRuntimeContext.getContextVal("x-bunit-id", false);
        return buId;
    }

    public static String timestamp() {
        String timestamp = CurrentRuntimeContext.getContextVal("timestamp", false);
        if (timestamp == null) {
            timestamp = String.valueOf(System.currentTimeMillis());
            CurrentRuntimeContext.setContextVal("timestamp", timestamp);
        }
        return timestamp;
    }

    public static void setClientType(String clientType) {
        CurrentRuntimeContext.setContextVal("x-client-type", clientType);
    }

    public static String getClientType() {
        return CurrentRuntimeContext.getContextVal("x-client-type", false);
    }

    public static void setSystemId(String systemId) {
        CurrentRuntimeContext.setContextVal("x-system-id", systemId);
    }

    public static String getSystemId() {
        return CurrentRuntimeContext.getContextVal("x-system-id", false);
    }

    public static <T> T getSystemId(Class<T> clazz) {
        return CurrentRuntimeContext.getContextVal("x-system-id", clazz, false);
    }

    public static void setIgnoreTenant(Boolean ignore) {
        CurrentRuntimeContext.setContextVal("x-ignore-tenant", ignore.toString());
    }

    public static boolean getIgnoreTenant() {
        return Boolean.parseBoolean(CurrentRuntimeContext.getContextVal("x-ignore-tenant", false));
    }

    public static boolean isDebugMode() {
        return ThreadLocalContext.exists("_debug_trace_context");
    }

    public static String getLanguage(boolean withCountry) {
        try {
            String language = CurrentRuntimeContext.getContextVal("Accept-Language", false);
            if (language == null) {
                return Locale.CHINA.getLanguage();
            }
            language = StringUtils.split((String)language, (String)",;")[0];
            if (withCountry) {
                return language;
            }
            return StringUtils.split((String)language, (String)"-")[0];
        }
        catch (Exception e) {
            return Locale.CHINA.getLanguage();
        }
    }

    public static Locale getLocale() {
        String language = CurrentRuntimeContext.getLanguage(true);
        if (language == null) {
            return null;
        }
        String[] parts = StringUtils.split((String)language, (String)"-");
        return parts.length < 2 ? new Locale(parts[0]) : new Locale(parts[0], parts[1]);
    }

    public static void setTimeZone(String timeZone) {
        CurrentRuntimeContext.setContextVal("x-timezone", timeZone);
    }

    public static String getTimeZone() {
        return CurrentRuntimeContext.getContextVal("x-timezone", false);
    }

    public static void setTenantDataSourceKey(String value) {
        CurrentRuntimeContext.setContextVal(CURRENT_TENANT_DS_KEY, value);
    }

    public static String getTenantDataSourceKey() {
        return CurrentRuntimeContext.getContextVal(CURRENT_TENANT_DS_KEY, false);
    }

    public static void setContextVal(String headerName, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        ThreadLocalContext.set(headerName, value);
        if (logger.isTraceEnabled()) {
            logger.trace("set current context:[{}={}]", (Object)headerName, (Object)value);
        }
    }

    public static String getContextVal(String contexrName, boolean validate) {
        String value = ThreadLocalContext.getStringValue(contexrName);
        if (validate && StringUtils.isBlank((CharSequence)value)) {
            throw new MendmixBaseException(500, "\u65e0\u6cd5\u83b7\u53d6\u4e0a\u4e0b\u6587[" + contexrName + "]\u4fe1\u606f");
        }
        return value;
    }

    public static boolean hasContextVal(String contextName) {
        return ThreadLocalContext.exists(contextName) || CurrentRuntimeContext.getContextVal(contextName, false) != null;
    }

    private static <V> V getContextVal(String contextName, Class<V> vClass, boolean validate) {
        String value = CurrentRuntimeContext.getContextVal(contextName, validate);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        Object newVal = value;
        if (vClass == Integer.class) {
            newVal = Integer.parseInt(value);
        } else if (vClass == Long.class) {
            newVal = Long.parseLong(value);
        }
        return (V)newVal;
    }
}

