/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.async;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dromara.mendmix.common.async.ICaller;
import org.dromara.mendmix.common.async.StandardThreadExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayRetryExecutor {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix");
    private long retryPeriodUnit;
    private int maxReties;
    private int queueCapacity;
    private final PriorityBlockingQueue<PriorityTask<?>> taskQueue = new PriorityBlockingQueue(1000);
    private ExecutorService executor;
    private AtomicBoolean closed = new AtomicBoolean(false);

    public int getRetryTaskNums() {
        return this.taskQueue.size();
    }

    public DelayRetryExecutor(int poolSize, int queueCapacity, int retryPeriodUnitMs, int maxReties) {
        this.queueCapacity = queueCapacity;
        this.retryPeriodUnit = retryPeriodUnitMs;
        this.maxReties = maxReties;
        this.executor = Executors.newFixedThreadPool(poolSize, new StandardThreadExecutor.StandardThreadFactory("DelayRetryExecutor"));
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                while (!DelayRetryExecutor.this.closed.get()) {
                    try {
                        PriorityTask task = (PriorityTask)DelayRetryExecutor.this.taskQueue.take();
                        if (task.getConsumer() == null) break;
                        if (task.nextFireTime - System.currentTimeMillis() > 0L) {
                            TimeUnit.MILLISECONDS.sleep(1000L);
                            DelayRetryExecutor.this.taskQueue.put(task);
                            continue;
                        }
                        task.run();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public <T> void submit(String traceId, ICaller<T> caller) {
        int taskCount = this.taskQueue.size();
        if (taskCount > this.queueCapacity) {
            logger.warn("<framework-logging> Retry queue task count:{} over max queueCapacity:{}", (Object)taskCount, (Object)this.queueCapacity);
            return;
        }
        this.taskQueue.add(new PriorityTask<T>(traceId, caller));
    }

    public void close() {
        this.closed.set(true);
        this.taskQueue.add(new PriorityTask(null, null));
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executor.shutdown();
        logger.info("<framework-logging> DelayRetryExecutor closed");
    }

    class PriorityTask<T>
    implements Runnable,
    Comparable<PriorityTask<T>> {
        String traceId;
        final ICaller<T> caller;
        int retryCount = 0;
        long nextFireTime;

        public PriorityTask(String traceId, ICaller<T> caller) {
            this(traceId, caller, System.currentTimeMillis() + this$0.retryPeriodUnit);
        }

        public PriorityTask(String traceId, ICaller<T> caller, long nextFireTime) {
            this.traceId = traceId;
            this.caller = caller;
            this.nextFireTime = nextFireTime;
        }

        public ICaller<T> getConsumer() {
            return this.caller;
        }

        @Override
        public void run() {
            try {
                logger.debug("<framework-logging> DelayRetry begin traceId:" + this.traceId);
                this.caller.call();
                logger.debug("<framework-logging> DelayRetry successed traceId:" + this.traceId);
            }
            catch (Exception e) {
                ++this.retryCount;
                if (this.retryCount == DelayRetryExecutor.this.maxReties) {
                    logger.error(String.format("<framework-logging> DelayRetry maxReties over %s,traceId:%s ", DelayRetryExecutor.this.maxReties, this.traceId), (Throwable)e);
                    return;
                }
                this.nextFireTime += (long)this.retryCount * DelayRetryExecutor.this.retryPeriodUnit;
                DelayRetryExecutor.this.taskQueue.add(this);
                logger.debug("<framework-logging> DelayRetry error ,reAdd to queue traceId:{},retryCount:{}" + this.traceId, (Object)this.retryCount);
            }
        }

        @Override
        public int compareTo(PriorityTask<T> o) {
            return (int)(this.nextFireTime - o.nextFireTime);
        }
    }
}

