/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.async;

import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RejectedExecutionException;
import org.dromara.mendmix.common.async.StandardThreadExecutor;

class ExecutorQueue
extends LinkedTransferQueue<Runnable> {
    private static final long serialVersionUID = -265236426751004839L;
    StandardThreadExecutor threadPoolExecutor;

    public void setStandardThreadExecutor(StandardThreadExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public boolean force(Runnable o) {
        if (this.threadPoolExecutor.isShutdown()) {
            throw new RejectedExecutionException("Executor not running, can't force a command into the queue");
        }
        return super.offer(o);
    }

    @Override
    public boolean offer(Runnable o) {
        int poolSize = this.threadPoolExecutor.getPoolSize();
        if (poolSize == this.threadPoolExecutor.getMaximumPoolSize()) {
            return super.offer(o);
        }
        if (this.threadPoolExecutor.getSubmittedTasksCount() <= poolSize) {
            return super.offer(o);
        }
        if (poolSize < this.threadPoolExecutor.getMaximumPoolSize()) {
            return false;
        }
        return super.offer(o);
    }
}

