/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.async;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.RandomUtils;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.async.RetryTask;
import org.dromara.mendmix.common.async.StandardThreadExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryAsyncTaskExecutor {
    private static Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.core.async");
    private static ThreadLocal<String> traceIdHolder = new ThreadLocal();
    private StandardThreadExecutor executor;
    private int maxRetry;
    private static volatile RetryAsyncTaskExecutor defaultExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RetryAsyncTaskExecutor getDefault() {
        if (defaultExecutor != null) {
            return defaultExecutor;
        }
        Class<RetryAsyncTaskExecutor> clazz = RetryAsyncTaskExecutor.class;
        synchronized (RetryAsyncTaskExecutor.class) {
            if (defaultExecutor != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return defaultExecutor;
            }
            defaultExecutor = new RetryAsyncTaskExecutor("__default", 10, 2000, 2);
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultExecutor;
        }
    }

    public RetryAsyncTaskExecutor(String taskName, int threads, int queueSize, int maxRetry) {
        this.maxRetry = maxRetry;
        this.executor = new StandardThreadExecutor(1, threads, 300L, TimeUnit.SECONDS, queueSize, (ThreadFactory)new StandardThreadExecutor.StandardThreadFactory(taskName + "-asyncTask"));
        logger.info("MENDMIX-TRACE-LOGGGING-->> AsyncTaskExecutor[{}] \u521d\u59cb\u5316\u5b8c\u6210 -> threads:{},queueSize:{},maxRetry:{}", new Object[]{taskName, threads, queueSize, maxRetry});
    }

    public void submitTask(RetryTask task) {
        this.executeWithRetry(task, 0);
    }

    public static void execute(RetryTask task) {
        RetryAsyncTaskExecutor.getDefault().executeWithRetry(task, 0);
    }

    private void executeWithRetry(final RetryTask task, int execNums) {
        int currentExecNums;
        final Map<String, String> contextHeaders = CurrentRuntimeContext.getContextHeaders();
        if (execNums >= this.maxRetry) {
            logger.warn("MENDMIX-TRACE-LOGGGING-->> {} executeWithRetry over maxRetry[{}]", (Object)task.traceId(), (Object)this.maxRetry);
            this.onFinalErrorProcess(task);
            return;
        }
        if ((currentExecNums = ++execNums) > 1) {
            try {
                Thread.sleep(RandomUtils.nextLong((long)500L, (long)1000L));
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.info("MENDMIX-TRACE-LOGGGING-->> {} {}/{} Begin", new Object[]{task.traceId(), currentExecNums, this.maxRetry});
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                contextHeaders.forEach((k, v) -> CurrentRuntimeContext.addContextHeader(k, v));
                traceIdHolder.set(task.traceId());
                try {
                    boolean result = task.process();
                    if (!result) {
                        RetryAsyncTaskExecutor.this.executeWithRetry(task, currentExecNums);
                    } else if (task.callback != null) {
                        try {
                            task.callback.onSuccess();
                        }
                        catch (Exception e) {
                            logger.error("MENDMIX-TRACE-LOGGGING-->> {} onSuccessCallback Error:{}", (Object)task.traceId(), (Object)e.getMessage());
                        }
                    }
                    if (currentExecNums > 1) {
                        logger.info("MENDMIX-TRACE-LOGGGING-->> {} {}/{} End -> {}", new Object[]{task.traceId(), currentExecNums, RetryAsyncTaskExecutor.this.maxRetry, result});
                    }
                }
                catch (Exception e) {
                    if (currentExecNums == RetryAsyncTaskExecutor.this.maxRetry) {
                        logger.error(String.format("%s %s/%s Error", task.traceId(), currentExecNums, RetryAsyncTaskExecutor.this.maxRetry), (Throwable)e);
                    } else {
                        logger.info("MENDMIX-TRACE-LOGGGING-->> {} {}/{} Error:{}", new Object[]{task.traceId(), currentExecNums, RetryAsyncTaskExecutor.this.maxRetry, e.getMessage()});
                    }
                    RetryAsyncTaskExecutor.this.executeWithRetry(task, currentExecNums);
                }
                finally {
                    traceIdHolder.remove();
                    ThreadLocalContext.unset();
                }
            }
        });
    }

    private void onFinalErrorProcess(RetryTask task) {
        try {
            if (task.callback != null) {
                task.callback.onFail();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Map<String, Object> status() {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        return map;
    }

    @PreDestroy
    public void shutdown() {
        try {
            this.executor.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getTraceId() {
        return traceIdHolder.get();
    }

    public static void close() {
        if (defaultExecutor != null) {
            defaultExecutor.shutdown();
        }
    }
}

