/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.async;

import org.apache.commons.lang3.RandomUtils;
import org.dromara.mendmix.common.async.ICaller;

public class SimpleRetry<T> {
    private ICaller<T> caller;
    private ICaller<T> errorCaller;

    public SimpleRetry(ICaller<T> caller) {
        this.caller = caller;
    }

    public SimpleRetry<T> onError(ICaller<T> errorCaller) {
        this.errorCaller = errorCaller;
        return this;
    }

    public T doRetry(int retries) {
        try {
            return this.caller.call();
        }
        catch (Exception e) {
            if (--retries > 0) {
                try {
                    Thread.sleep(RandomUtils.nextLong((long)10L, (long)500L));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return this.doRetry(retries);
            }
            if (this.errorCaller != null) {
                try {
                    return this.errorCaller.call();
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            throw new RuntimeException(e);
        }
    }
}

