/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.async;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.dromara.mendmix.common.async.ExecutorQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardThreadExecutor
extends ThreadPoolExecutor {
    private static Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.common.concurrent");
    public static final int DEFAULT_MIN_THREADS = 1;
    public static final int DEFAULT_MAX_THREADS = Runtime.getRuntime().availableProcessors() + 1;
    public static final int DEFAULT_MAX_IDLE_TIME = 60000;
    private static final ThreadFactory defaultThreadFactory = new StandardThreadFactory("StandardThreadPool");
    protected AtomicInteger submittedTasksCount;
    private int maxSubmittedTaskCount;

    public StandardThreadExecutor() {
        this(1, DEFAULT_MAX_THREADS);
    }

    public StandardThreadExecutor(int coreThread, int maxThreads) {
        this(coreThread, maxThreads, maxThreads);
    }

    public StandardThreadExecutor(int coreThread, int maxThreads, long keepAliveTime, TimeUnit unit) {
        this(coreThread, maxThreads, keepAliveTime, unit, maxThreads);
    }

    public StandardThreadExecutor(int coreThreads, int maxThreads, int queueCapacity) {
        this(coreThreads, maxThreads, queueCapacity, defaultThreadFactory);
    }

    public StandardThreadExecutor(int coreThreads, int maxThreads, int queueCapacity, ThreadFactory threadFactory) {
        this(coreThreads, maxThreads, 60000L, TimeUnit.MILLISECONDS, queueCapacity, threadFactory);
    }

    public StandardThreadExecutor(int coreThreads, int maxThreads, long keepAliveTime, TimeUnit unit, int queueCapacity) {
        this(coreThreads, maxThreads, keepAliveTime, unit, queueCapacity, defaultThreadFactory);
    }

    public StandardThreadExecutor(int coreThreads, int maxThreads, long keepAliveTime, TimeUnit unit, int queueCapacity, ThreadFactory threadFactory) {
        this(coreThreads, maxThreads, keepAliveTime, unit, queueCapacity, threadFactory, (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
    }

    public StandardThreadExecutor(int coreThreads, int maxThreads, long keepAliveTime, TimeUnit unit, int queueCapacity, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(coreThreads, maxThreads, keepAliveTime, unit, new ExecutorQueue(), threadFactory, handler);
        ((ExecutorQueue)this.getQueue()).setStandardThreadExecutor(this);
        this.submittedTasksCount = new AtomicInteger(0);
        this.maxSubmittedTaskCount = queueCapacity + maxThreads;
    }

    @Override
    public void execute(Runnable command) {
        block3: {
            int count = this.submittedTasksCount.incrementAndGet();
            if (count > this.maxSubmittedTaskCount) {
                this.submittedTasksCount.decrementAndGet();
                this.getRejectedExecutionHandler().rejectedExecution(command, this);
            }
            try {
                super.execute(command);
            }
            catch (RejectedExecutionException rx) {
                if (((ExecutorQueue)this.getQueue()).force(command)) break block3;
                this.submittedTasksCount.decrementAndGet();
                this.getRejectedExecutionHandler().rejectedExecution(command, this);
            }
        }
    }

    public int getSubmittedTasksCount() {
        return this.submittedTasksCount.get();
    }

    public int getMaxSubmittedTaskCount() {
        return this.maxSubmittedTaskCount;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        this.submittedTasksCount.decrementAndGet();
        this.printException(r, t);
    }

    private void printException(Runnable r, Throwable t) {
        if (t == null && r instanceof Future) {
            try {
                Future future = (Future)((Object)r);
                if (future.isDone()) {
                    future.get();
                }
            }
            catch (CancellationException ce) {
                t = ce;
            }
            catch (ExecutionException ee) {
                t = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (t != null) {
            logger.error(t.getMessage(), t);
        }
    }

    public static class StandardThreadFactory
    implements ThreadFactory {
        private final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        public StandardThreadFactory(String namePrefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = namePrefix + "-" + this.poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

