/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.counter;

import java.util.concurrent.atomic.AtomicInteger;

public class CirculateCounter {
    private int maxCount;
    private AtomicInteger counter = new AtomicInteger(0);

    public CirculateCounter(int maxCount) {
        if (maxCount <= 0) {
            throw new IllegalArgumentException("maxCount must > 0");
        }
        this.maxCount = maxCount;
    }

    public int next() {
        if (this.maxCount == 1) {
            return 0;
        }
        return this.counter.updateAndGet(x -> x >= this.maxCount ? 0 : x + 1);
    }
}

