/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.crypt;

import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.GlobalConstants;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.crypt.AES;
import org.dromara.mendmix.common.crypt.Base58;
import org.dromara.mendmix.common.util.DigestUtils;
import org.dromara.mendmix.common.util.ResourceUtils;

public class CustomEncryptor {
    private static CustomEncryptor defaultEncryptor;
    private long timeOffsetMillis;
    private boolean timeliness;
    private byte[] cryptKeyBytes;

    public CustomEncryptor(String cryptKey, boolean timeliness) {
        this(cryptKey, timeliness, 300000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CustomEncryptor useDefault() {
        if (defaultEncryptor != null) return defaultEncryptor;
        Class<CustomEncryptor> clazz = CustomEncryptor.class;
        synchronized (CustomEncryptor.class) {
            String secretKey = ResourceUtils.getAnyProperty("mendmix-cloud.crypto.secret", "global.crypto.secret");
            if (secretKey == null) {
                secretKey = GlobalConstants.DEFAULT_CRIPT_KEY;
            }
            defaultEncryptor = new CustomEncryptor(secretKey, false);
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultEncryptor;
        }
    }

    public CustomEncryptor(String cryptKey, boolean timeliness, long timeOffsetMillis) {
        this.timeliness = timeliness;
        this.timeOffsetMillis = timeOffsetMillis;
        StringBuilder sb = new StringBuilder();
        String keyMd5 = DigestUtils.md5(cryptKey);
        sb.append(keyMd5.substring(2, 4)).append("#");
        sb.append(keyMd5.substring(5, 10)).append("@");
        sb.append(keyMd5.substring(26, 28).toUpperCase()).append("&");
        sb.append(keyMd5.substring(17, 20)).append("$");
        this.cryptKeyBytes = sb.toString().getBytes();
    }

    public String encrypt(String plaintext) {
        return this.encrypt(plaintext, true);
    }

    public String encrypt(String plaintext, boolean withPrefix) {
        if (StringUtils.isBlank((CharSequence)plaintext)) {
            return null;
        }
        try {
            if (this.timeliness) {
                plaintext = plaintext.concat(String.valueOf(System.currentTimeMillis()));
            }
            byte[] bytes = AES.encrypt(plaintext.getBytes(), this.cryptKeyBytes);
            String ciphertext = Base58.encode(bytes);
            return withPrefix ? "{Cipher}" + ciphertext : ciphertext;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String decrypt(String ciphertext) {
        if (StringUtils.isBlank((CharSequence)ciphertext)) {
            return null;
        }
        if (ciphertext.startsWith("{Cipher}")) {
            ciphertext = ciphertext.replace("{Cipher}", "");
        }
        try {
            byte[] bytes = Base58.decode(ciphertext);
            bytes = AES.decrypt(bytes, this.cryptKeyBytes);
            String plaintext = new String(bytes);
            if (this.timeliness) {
                long timestamp = Long.parseLong(plaintext.substring(plaintext.length() - 13));
                if (System.currentTimeMillis() - timestamp > this.timeOffsetMillis) {
                    throw new MendmixBaseException("token\u5df2\u5931\u6548");
                }
                plaintext = plaintext.substring(0, plaintext.length() - 13);
            }
            return plaintext;
        }
        catch (MendmixBaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        CustomEncryptor aesWrapper = new CustomEncryptor("xyz", true);
        String encrypt = aesWrapper.encrypt("hello");
        System.out.println(encrypt);
        System.out.println(aesWrapper.decrypt(encrypt));
    }
}

