/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.crypt;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.dromara.mendmix.common.crypt.Base64;

public class RSA {
    private static final String RSA_ALGORITHM = "RSA";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final String KEY_ALGORITHM = "RSA";
    private static final String CIPHER_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private static final int KEY_SIZE = 1024;
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static void main(String[] args) throws Exception {
        String PLAIN_TEXT = "srtt46y7u";
        PublicKey publicKey = RSA.loadPublicKey(new File("/Users/jiangwei/logs/rsa_public_key.pem"));
        String encodedText = RSA.encrypt(publicKey, PLAIN_TEXT);
        System.out.println("RSA encoded: " + encodedText);
        PrivateKey privateKey = RSA.loadPrivateKey(new File("/Users/jiangwei/logs/rsa_private_pkcs8.pem"));
        System.out.println("RSA decoded: " + RSA.decrypt(privateKey, encodedText));
    }

    public static RSAKeyPair generateKeyPair(int keySize) {
        KeyPairGenerator keyPairGen = null;
        try {
            keyPairGen = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        keyPairGen.initialize(keySize, new SecureRandom());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        return new RSAKeyPair(privateKey, publicKey);
    }

    public static String[] generateKeyStrPair(int keySize) {
        RSAKeyPair keyPair = RSA.generateKeyPair(keySize);
        RSAPrivateKey privateKey = keyPair.getPrivateKey();
        RSAPublicKey publicKey = keyPair.getPublicKey();
        try {
            String publicKeyString = Base64.encodeToString(publicKey.getEncoded(), true);
            String privateKeyString = Base64.encodeToString(privateKey.getEncoded(), true);
            return new String[]{publicKeyString, privateKeyString};
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PublicKey loadPublicKey(File file) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            PublicKey publicKey = RSA.loadPublicKey(inputStream);
            return publicKey;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static PublicKey loadPublicKey(InputStream in) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String readLine = null;
            StringBuilder sb = new StringBuilder();
            while ((readLine = br.readLine()) != null) {
                if (readLine.charAt(0) == '-') continue;
                sb.append(readLine);
                sb.append('\r');
            }
            byte[] bytes = Base64.decode(sb.toString());
            return RSA.loadPublicKey(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("\u516c\u94a5\u6570\u636e\u6d41\u8bfb\u53d6\u9519\u8bef");
        }
        catch (NullPointerException e) {
            throw new RuntimeException("\u516c\u94a5\u8f93\u5165\u6d41\u4e3a\u7a7a");
        }
    }

    public static PublicKey loadPublicKey(String pubKeyString) {
        byte[] bytes = Base64.decode(pubKeyString);
        return RSA.loadPublicKey(bytes);
    }

    public static PrivateKey loadPrivateKey(File file) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            PrivateKey privateKey = RSA.loadPrivateKey(inputStream);
            return privateKey;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static PrivateKey loadPrivateKey(InputStream in) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String readLine = null;
            StringBuilder sb = new StringBuilder();
            while ((readLine = br.readLine()) != null) {
                if (readLine.charAt(0) == '-') continue;
                sb.append(readLine);
                sb.append('\r');
            }
            byte[] bytes = Base64.decode(sb.toString());
            return RSA.loadPrivateKey(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("\u79c1\u94a5\u6570\u636e\u8bfb\u53d6\u9519\u8bef");
        }
        catch (NullPointerException e) {
            throw new RuntimeException("\u79c1\u94a5\u8f93\u5165\u6d41\u4e3a\u7a7a");
        }
    }

    public static PrivateKey loadPrivateKey(String priKeyString) {
        byte[] bytes = Base64.decode(priKeyString);
        return RSA.loadPrivateKey(bytes);
    }

    public static PublicKey loadPublicKey(byte[] keyBytes) {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyBytes);
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = factory.generatePublic(x509EncodedKeySpec);
            return publicKey;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static PrivateKey loadPrivateKey(byte[] keyBytes) {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyBytes);
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = factory.generatePrivate(pkcs8EncodedKeySpec);
            return privateKey;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PrivateKey loadPrivateKeyFromKeyStore(String location, String alias, String storeType, String storePass, String keyPass) {
        try {
            storeType = null == storeType ? KeyStore.getDefaultType() : storeType;
            keyPass = keyPass == null ? storePass : keyPass;
            KeyStore keyStore = KeyStore.getInstance(storeType);
            FileInputStream is = new FileInputStream(location);
            keyStore.load(is, storePass.toCharArray());
            return (PrivateKey)keyStore.getKey(alias, keyPass.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PrivateKey loadPrivateKeyFromKeyStore(KeyStore keyStore, String alias, String keyPass) {
        try {
            return (PrivateKey)keyStore.getKey(alias, keyPass.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PublicKey loadPublicKeyFromKeyStore(String location, String alias, String storeType, String storePass, String keyPass) {
        try {
            storeType = null == storeType ? KeyStore.getDefaultType() : storeType;
            keyPass = keyPass == null ? storePass : keyPass;
            KeyStore keyStore = KeyStore.getInstance(storeType);
            FileInputStream is = new FileInputStream(location);
            keyStore.load(is, storePass.toCharArray());
            RSAPrivateCrtKey key = (RSAPrivateCrtKey)keyStore.getKey(alias, keyPass.toCharArray());
            RSAPublicKeySpec spec = new RSAPublicKeySpec(key.getModulus(), key.getPublicExponent());
            PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(spec);
            return publicKey;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PublicKey loadPublicKeyFromKeyStore(KeyStore keyStore, String alias, String keyPass) {
        try {
            RSAPrivateCrtKey key = (RSAPrivateCrtKey)keyStore.getKey(alias, keyPass.toCharArray());
            RSAPublicKeySpec spec = new RSAPublicKeySpec(key.getModulus(), key.getPublicExponent());
            PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(spec);
            return publicKey;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PublicKey loadPublicKeyFromCert(String certPath) throws CertificateException, FileNotFoundException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            FileInputStream in = new FileInputStream(certPath);
            Certificate crt = cf.generateCertificate(in);
            PublicKey publicKey = crt.getPublicKey();
            return publicKey;
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] encrypt(PublicKey key, byte[] plainBytes) {
        ByteArrayOutputStream out = null;
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(1, key);
            int inputLen = plainBytes.length;
            if (inputLen <= 117) {
                byte[] byArray2 = cipher.doFinal(plainBytes);
                return byArray2;
            }
            out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(plainBytes, offSet, 117) : cipher.doFinal(plainBytes, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u65e0\u6b64\u89e3\u5bc6\u7b97\u6cd5");
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            byte[] byArray3 = null;
            return byArray3;
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("\u89e3\u5bc6\u79c1\u94a5\u975e\u6cd5,\u8bf7\u68c0\u67e5");
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException("\u5bc6\u6587\u957f\u5ea6\u975e\u6cd5");
        }
        catch (BadPaddingException e) {
            throw new RuntimeException("\u5bc6\u6587\u6570\u636e\u5df2\u635f\u574f");
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String encrypt(PublicKey key, String plainText) {
        byte[] encodeBytes = RSA.encrypt(key, plainText.getBytes(DEFAULT_CHARSET));
        return Base64.encodeToString(encodeBytes, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String decrypt(PrivateKey key, byte[] encodedText) {
        ByteArrayOutputStream out = null;
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(2, key);
            int inputLen = encodedText.length;
            if (inputLen <= 128) {
                String string2 = new String(cipher.doFinal(encodedText), DEFAULT_CHARSET);
                return string2;
            }
            out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encodedText, offSet, 128) : cipher.doFinal(encodedText, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 128;
            }
            String string = new String(out.toByteArray(), DEFAULT_CHARSET);
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u65e0\u6b64\u89e3\u5bc6\u7b97\u6cd5");
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            String string3 = null;
            return string3;
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("\u89e3\u5bc6\u79c1\u94a5\u975e\u6cd5,\u8bf7\u68c0\u67e5");
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException("\u5bc6\u6587\u957f\u5ea6\u975e\u6cd5");
        }
        catch (BadPaddingException e) {
            throw new RuntimeException("\u5bc6\u6587\u6570\u636e\u5df2\u635f\u574f");
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String decrypt(PrivateKey key, String encodedText) {
        byte[] bytes = Base64.decode(encodedText);
        return RSA.decrypt(key, bytes);
    }

    public static String privateDecrypt(String data, RSAPrivateKey privateKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            return new String(RSA.rsaSplitCodec(cipher, 2, org.apache.commons.codec.binary.Base64.decodeBase64((String)data), privateKey.getModulus().bitLength()), DEFAULT_ENCODING);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    public static String publicEncrypt(String data, RSAPublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
            return org.apache.commons.codec.binary.Base64.encodeBase64URLSafeString((byte[])RSA.rsaSplitCodec(cipher, 1, data.getBytes(DEFAULT_ENCODING), publicKey.getModulus().bitLength()));
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    public static RSAPrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(org.apache.commons.codec.binary.Base64.decodeBase64((String)privateKey));
        RSAPrivateKey key = (RSAPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
        return key;
    }

    public static RSAPublicKey getPublicKey(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(org.apache.commons.codec.binary.Base64.decodeBase64((String)publicKey));
        RSAPublicKey key = (RSAPublicKey)keyFactory.generatePublic(x509KeySpec);
        return key;
    }

    private static byte[] rsaSplitCodec(Cipher cipher, int opmode, byte[] datas, int keySize) {
        int maxBlock = 0;
        maxBlock = opmode == 2 ? keySize / 8 : keySize / 8 - 11;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        try {
            while (datas.length > offSet) {
                byte[] buff = datas.length - offSet > maxBlock ? cipher.doFinal(datas, offSet, maxBlock) : cipher.doFinal(datas, offSet, datas.length - offSet);
                out.write(buff, 0, buff.length);
                offSet = ++i * maxBlock;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u89e3\u5bc6\u9600\u503c\u4e3a[" + maxBlock + "]\u7684\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38", e);
        }
        byte[] resultDatas = out.toByteArray();
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultDatas;
    }

    public static class RSAKeyPair {
        private RSAPrivateKey privateKey;
        private RSAPublicKey publicKey;

        public RSAKeyPair(RSAPrivateKey privateKey, RSAPublicKey publicKey) {
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        }

        public RSAPrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public RSAPublicKey getPublicKey() {
            return this.publicKey;
        }
    }
}

