/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.guid;

import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.RandomUtils;
import org.dromara.mendmix.common.GlobalContext;
import org.dromara.mendmix.common.util.DateUtils;
import org.dromara.mendmix.common.util.StringConverter;

public class TimestampGUIDGenarator {
    private static final String TIME_PATTERN = "yyyyMMddHHmmss";
    private final AtomicInteger NEXT_COUNTER;
    private int incrMin;
    private int incrMax;

    public TimestampGUIDGenarator(int incrMax) {
        this.incrMin = Integer.parseInt("1" + String.valueOf(incrMax).substring(1).replaceAll("[0-9]{1}", "0"));
        this.incrMax = incrMax;
        this.NEXT_COUNTER = new AtomicInteger(RandomUtils.nextInt((int)this.incrMin, (int)(incrMax / 2)));
    }

    public String next(String ... prefixs) {
        StringBuilder sb = new StringBuilder();
        if (prefixs != null && prefixs.length > 0 && prefixs[0] != null) {
            sb.append(prefixs[0]);
        }
        sb.append(DateUtils.format(new Date(), TIME_PATTERN));
        sb.append(GlobalContext.getWorkerId());
        sb.append(this.buildIncrNumSequence());
        return sb.toString();
    }

    private String buildIncrNumSequence() {
        int next = this.NEXT_COUNTER.incrementAndGet();
        if (this.incrMax - next < 5) {
            next = this.NEXT_COUNTER.updateAndGet(x -> x >= this.incrMax ? RandomUtils.nextInt((int)this.incrMin, (int)(this.incrMax / 2)) : x + 1);
        }
        String seq = String.valueOf(next);
        return StringConverter.paddingZeros(seq, 5);
    }

    public static void main(String[] args) {
        TimestampGUIDGenarator genarator = new TimestampGUIDGenarator(9999);
        for (int i = 0; i < 10; ++i) {
            System.out.println(genarator.next(new String[0]));
        }
    }
}

