/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.dromara.mendmix.common.http.HttpClientProvider;
import org.dromara.mendmix.common.http.HttpMethod;
import org.dromara.mendmix.common.http.HttpRequestEntity;
import org.dromara.mendmix.common.http.HttpResponseEntity;
import org.dromara.mendmix.common.http.SSLHelper;

public class ApacheHttpClient
implements HttpClientProvider {
    private static RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(readTimeout).setConnectionRequestTimeout(readTimeout).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponseEntity execute(HttpRequestEntity requestEntity) throws IOException {
        SSLConnectionSocketFactory sslConnectionSocketFactory;
        CredentialsProvider credsProvider = null;
        try {
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(SSLHelper.getSslContext(), SSLHelper.getHostnameVerifier());
        }
        catch (Exception e) {
            sslConnectionSocketFactory = SSLConnectionSocketFactory.getSocketFactory();
        }
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultCredentialsProvider(credsProvider).setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
        CloseableHttpResponse response = null;
        try {
            HttpUriRequest request = ApacheHttpClient.buildHttpUriRequest(requestEntity.getUri(), requestEntity);
            response = httpClient.execute(request);
            HttpResponseEntity responseEntity = new HttpResponseEntity();
            responseEntity.setStatusCode(response.getStatusLine().getStatusCode());
            responseEntity.setMessage(response.getStatusLine().getReasonPhrase());
            if (response.getEntity() != null) {
                String body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)requestEntity.getCharset());
                responseEntity.setBody(body);
            }
            HttpResponseEntity httpResponseEntity = responseEntity;
            return httpResponseEntity;
        }
        finally {
            if (response != null) {
                response.close();
            }
            try {
                httpClient.close();
            }
            catch (IOException iOException) {}
            requestEntity.unset();
        }
    }

    private static HttpUriRequest buildHttpUriRequest(String url, HttpRequestEntity requestEntity) throws IOException {
        Set<Map.Entry<String, Object>> entrySet;
        RequestBuilder builder = null;
        if (HttpMethod.POST == requestEntity.getMethod()) {
            builder = RequestBuilder.post().setUri(url);
        } else if (HttpMethod.GET == requestEntity.getMethod()) {
            builder = RequestBuilder.get();
        }
        builder.setUri(url).setConfig(requestConfig);
        if (requestEntity.getQueryParams() != null) {
            entrySet = requestEntity.getQueryParams().entrySet();
            for (Map.Entry<String, Object> e : entrySet) {
                if (e.getValue() == null) continue;
                builder.addParameter(e.getKey(), e.getValue().toString());
            }
        }
        if (requestEntity.getHeaders() != null) {
            entrySet = requestEntity.getHeaders().entrySet();
            for (Map.Entry<String, Object> e : entrySet) {
                if (e.getValue() == null) continue;
                builder.addHeader(e.getKey(), (String)e.getValue());
            }
        }
        builder.addHeader("Content-Type", requestEntity.getContentType());
        StringEntity httpEntity = null;
        if (StringUtils.isNotBlank((CharSequence)requestEntity.getBody())) {
            httpEntity = new StringEntity(requestEntity.getBody(), requestEntity.getCharset());
        } else if (requestEntity.getFormParams() != null) {
            Set<Map.Entry<String, Object>> formEntries = requestEntity.getFormParams().entrySet();
            if (requestEntity.isMultipart()) {
                MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
                for (Map.Entry<String, Object> entry : formEntries) {
                    Object entryValue = entry.getValue();
                    if (entryValue == null) continue;
                    if (entryValue instanceof HttpRequestEntity.FileItem) {
                        HttpRequestEntity.FileItem fileItem = (HttpRequestEntity.FileItem)entryValue;
                        ContentType contentType = null;
                        if (fileItem.getMimeType() != null) {
                            contentType = ContentType.create((String)fileItem.getMimeType());
                        }
                        entityBuilder.addBinaryBody(entry.getKey(), fileItem.getContent(), contentType, fileItem.getFileName());
                        continue;
                    }
                    entityBuilder.addTextBody(entry.getKey(), entryValue.toString());
                }
                httpEntity = entityBuilder.build();
            } else {
                ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(formEntries.size());
                for (Map.Entry<String, Object> entry : formEntries) {
                    if (entry.getValue() == null) continue;
                    parameters.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
                }
                try {
                    httpEntity = new UrlEncodedFormEntity(parameters, "utf-8");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (httpEntity != null) {
            builder.setEntity((HttpEntity)httpEntity);
        }
        if (requestEntity.getBasicAuth() != null) {
            builder.addHeader("Authorization", requestEntity.getBasicAuth().getEncodeBasicAuth());
        }
        return builder.build();
    }
}

