/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.http;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.GlobalConstants;
import org.dromara.mendmix.common.http.ProxyResolver;
import org.dromara.mendmix.common.util.ResourceUtils;

public class HostMappingHolder {
    private static final String PATH_SEPARATOR = "/";
    private static final String LOCALHOST = "localhost";
    private static final String LB_SCHAME = "lb://";
    private static Map<String, String> proxyUriMappings = new HashMap<String, String>();
    private static Map<String, String> contextPathMappings = new HashMap<String, String>();
    private static ProxyResolver proxyResolver;

    public static void setProxyResolver(ProxyResolver proxyResolver) {
        HostMappingHolder.proxyResolver = proxyResolver;
    }

    public static void reload() {
        HashMap<String, String> originMappings = new HashMap<String, String>(proxyUriMappings);
        proxyUriMappings.clear();
        HostMappingHolder.getProxyUrlMappings();
        originMappings.forEach((k, v) -> {
            if (!proxyUriMappings.containsKey(k)) {
                proxyUriMappings.put((String)k, (String)v);
            }
        });
        System.out.println(">>Custom UriMappings:");
        proxyUriMappings.forEach((k, v) -> System.out.println(String.format(" - %s \u2192 %s", k, v)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getProxyUrlMappings() {
        if (!proxyUriMappings.isEmpty()) {
            return proxyUriMappings;
        }
        Map<String, String> map = proxyUriMappings;
        synchronized (map) {
            if (!proxyUriMappings.isEmpty()) {
                return proxyUriMappings;
            }
            Map<String, String> mappings = ResourceUtils.getMappingValues("mendmix-cloud.loadbalancer.customize.mapping");
            for (String serviceId : mappings.keySet()) {
                String proxyUrl = HostMappingHolder.fomatProxyUrl(mappings.get(serviceId));
                proxyUriMappings.put(serviceId.toLowerCase(), proxyUrl);
            }
            if (proxyUriMappings.isEmpty()) {
                proxyUriMappings.put("mendmix", "mendmix");
            }
        }
        return proxyUriMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getContextPathMappings() {
        if (!contextPathMappings.isEmpty()) {
            return contextPathMappings;
        }
        Map<String, String> map = contextPathMappings;
        synchronized (map) {
            if (!contextPathMappings.isEmpty()) {
                return contextPathMappings;
            }
            Map<String, String> mappingValues = ResourceUtils.getMappingValues("mendmix-cloud.loadbalancer.contextPath.mapping");
            contextPathMappings = new HashMap<String, String>(mappingValues.size());
            for (String serviceId : mappingValues.keySet()) {
                String contextPath = mappingValues.get(serviceId);
                if (!contextPath.startsWith(GlobalConstants.PATH_SEPARATOR)) {
                    contextPath = GlobalConstants.PATH_SEPARATOR + contextPath;
                }
                contextPathMappings.put(serviceId, contextPath);
            }
            if (contextPathMappings.isEmpty()) {
                contextPathMappings.put("mendmix", "mendmix");
            }
        }
        return contextPathMappings;
    }

    private static String fomatProxyUrl(String mappingUrl) {
        if (!mappingUrl.startsWith("http://") && !mappingUrl.startsWith("https://")) {
            mappingUrl = "http://" + mappingUrl;
        }
        if (mappingUrl.endsWith(PATH_SEPARATOR)) {
            mappingUrl = mappingUrl.substring(0, mappingUrl.length() - 1);
        }
        return mappingUrl;
    }

    public static String getProxyUrlMapping(String name) {
        return HostMappingHolder.getProxyUrlMappings().get(name.toLowerCase());
    }

    public static void addProxyUrlMapping(String name, String mappingUrl) {
        HostMappingHolder.getProxyUrlMappings().put(name.toLowerCase(), mappingUrl);
    }

    public static boolean containsProxyUrlMapping(String name) {
        return HostMappingHolder.getProxyUrlMappings().containsKey(name.toLowerCase());
    }

    public static String getContextPathMapping(String name) {
        return HostMappingHolder.getContextPathMappings().get(name.toLowerCase());
    }

    public static boolean containsContextPathMapping(String name) {
        return HostMappingHolder.getContextPathMappings().containsKey(name.toLowerCase());
    }

    public static String resolveUrl(String url) {
        return HostMappingHolder.resolveUrl(url, 3);
    }

    private static String resolveUrl(String url, int recursionLimit) {
        String realUrl = null;
        if (--recursionLimit < 0) {
            realUrl = url;
            if (realUrl.startsWith(LB_SCHAME)) {
                realUrl = realUrl.replace(LB_SCHAME, "http://");
            }
            System.err.println("resolveUrl[" + url + "]\u9012\u5f52\u8d85\u8fc7\u9650\u5236\uff0c\u8fd4\u56de:" + realUrl);
            return realUrl;
        }
        String serviceId = StringUtils.split((String)url, (String)PATH_SEPARATOR)[1].toLowerCase();
        if (serviceId.startsWith(LOCALHOST)) {
            return url;
        }
        Map<String, String> baseNameMappings = HostMappingHolder.getProxyUrlMappings();
        if (baseNameMappings.containsKey(serviceId)) {
            realUrl = baseNameMappings.get(serviceId);
        } else if (proxyResolver != null && !serviceId.contains(".")) {
            realUrl = proxyResolver.resolve(serviceId);
        }
        if (realUrl != null) {
            if (realUrl.startsWith(LB_SCHAME)) {
                realUrl = HostMappingHolder.resolveUrl(realUrl, recursionLimit);
            }
            if (HostMappingHolder.containsContextPathMapping(serviceId)) {
                realUrl = realUrl + HostMappingHolder.getContextPathMapping(serviceId);
            }
            String baseUrl = url.substring(0, url.indexOf(serviceId) + serviceId.length());
            return url.replace(baseUrl, realUrl);
        }
        return url;
    }
}

