/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.GlobalContext;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.crypt.Base64;
import org.dromara.mendmix.common.http.HttpClientProvider;
import org.dromara.mendmix.common.http.HttpMethod;
import org.dromara.mendmix.common.http.HttpResponseEntity;
import org.dromara.mendmix.common.model.AuthUser;
import org.dromara.mendmix.common.util.BeanUtils;
import org.dromara.mendmix.common.util.HttpUtils;
import org.dromara.mendmix.common.util.JsonUtils;
import org.dromara.mendmix.common.util.MimeTypeUtils;
import org.dromara.mendmix.common.util.ParameterUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.common.util.TokenGenerator;

public class HttpRequestEntity {
    public static final String HTTP_THREAD_NAME = "http-";
    private String uri;
    private HttpMethod method;
    private String charset;
    private String contentType;
    private Map<String, String> headers;
    private Map<String, Object> queryParams;
    private Map<String, Object> formParams;
    private String body;
    private BasicAuthParams basicAuth;
    private boolean logging = true;
    private boolean multipart;
    private String boundary;
    private boolean fallbackHitCache;
    private Proxy proxy;

    private HttpRequestEntity() {
    }

    public static HttpRequestEntity create(HttpMethod method) {
        return new HttpRequestEntity().method(method);
    }

    public static HttpRequestEntity post(String uri) {
        return new HttpRequestEntity().method(HttpMethod.POST).uri(uri);
    }

    public static HttpRequestEntity get(String uri) {
        return new HttpRequestEntity().method(HttpMethod.GET).uri(uri);
    }

    public String getCharset() {
        if (this.charset == null) {
            this.charset = HttpRequestEntity.parseContentTypeCharset(this.contentType);
        }
        return this.charset;
    }

    public HttpRequestEntity proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public HttpRequestEntity fallbackHitCache() {
        this.fallbackHitCache = HttpClientProvider.fallbackEnabled;
        return this;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getUri() {
        return this.uri;
    }

    public HttpRequestEntity uri(String uri) {
        this.uri = uri;
        return this;
    }

    public HttpRequestEntity logging(boolean logging) {
        this.logging = logging;
        return this;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public HttpRequestEntity internalCall() {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        if (!this.headers.containsKey("x-invoke-token")) {
            this.header("x-invoke-token", TokenGenerator.generateWithSign());
        }
        return this.header("x-internal-request", Boolean.TRUE.toString());
    }

    public HttpRequestEntity backendInternalCall() {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.header("x-resp-keep", Boolean.TRUE.toString());
        this.header("x-ignore-tenant", Boolean.TRUE.toString());
        this.header("x-ignore-auth", Boolean.TRUE.toString());
        this.header("User-Agent", "backend-client");
        return this.internalCall();
    }

    public HttpRequestEntity useContext() {
        AuthUser currentUser;
        Map<String, String> contextHeaders = CurrentRuntimeContext.getContextHeaders();
        this.headers(contextHeaders);
        if (!this.getHeaders().containsKey("x-invoke-token")) {
            this.header("x-invoke-token", TokenGenerator.generateWithSign());
        }
        if (!this.headers.containsKey("x-auth-user") && (currentUser = CurrentRuntimeContext.getCurrentUser()) != null) {
            this.header("x-auth-user", currentUser.toEncodeString());
        }
        return this;
    }

    public boolean isFallbackHitCache() {
        return this.fallbackHitCache;
    }

    public String getFallbackHitCacheKey() {
        if (!this.fallbackHitCache) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.method).append(this.uri);
        if (this.queryParams != null && !this.queryParams.isEmpty()) {
            builder.append(ParameterUtils.mapToQueryParams(this.queryParams));
        }
        if (this.body != null) {
            builder.append(this.body);
        }
        if (this.headers != null) {
            if (this.headers.containsKey("x-system-id")) {
                builder.append(this.headers.get("x-system-id"));
            }
            if (this.headers.containsKey("x-tenant-id")) {
                builder.append(this.headers.get("x-tenant-id"));
            }
        }
        return "httpFallbackCache:" + DigestUtils.md5((String)builder.toString());
    }

    public HttpRequestEntity method(HttpMethod method) {
        this.method = method;
        return this;
    }

    public HttpRequestEntity charset(String charset) {
        this.charset = charset;
        return this;
    }

    public String getContentType() {
        if (StringUtils.isBlank((CharSequence)this.contentType)) {
            return "application/json; charset=utf-8";
        }
        return this.contentType;
    }

    public HttpRequestEntity contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeader(String headerName) {
        return this.headers == null ? null : this.headers.get(headerName);
    }

    public boolean hasHeader(String headerName) {
        return this.headers != null && this.headers.containsKey(headerName);
    }

    public HttpRequestEntity headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public HttpRequestEntity header(String name, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return this;
        }
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        if (this.headers == null) {
            this.headers = new HashMap<String, String>(3);
        }
        this.headers.put(name, value);
        return this;
    }

    public HttpRequestEntity headerIfAbsent(String name, String value) {
        if (!this.hasHeader(name)) {
            this.header(name, value);
        }
        return this;
    }

    public Map<String, Object> getQueryParams() {
        return this.queryParams;
    }

    public HttpRequestEntity queryParams(Map<String, Object> queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    public HttpRequestEntity queryParam(String name, Object value) {
        if (value == null || StringUtils.isBlank((CharSequence)value.toString())) {
            return this;
        }
        if (this.queryParams == null) {
            this.queryParams = new HashMap<String, Object>(3);
        }
        this.queryParams.put(name, value);
        return this;
    }

    public Map<String, Object> getFormParams() {
        return this.formParams;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public HttpRequestEntity fileParam(String name, File file) {
        if (this.formParams == null) {
            this.formParams = new HashMap<String, Object>();
        }
        this.formParams.put(name, new FileItem(file));
        if (this.contentType == null) {
            this.contentType = "multipart/form-data;charset=utf-8";
        }
        if (!this.multipart) {
            this.multipart = true;
            this.boundary = String.valueOf(System.nanoTime());
            this.contentType = this.contentType + ";boundary=" + this.boundary;
        }
        return this;
    }

    public HttpRequestEntity fileParam(String name, String originalFilename, InputStream inputStream, String mimeType, long size) {
        if (this.formParams == null) {
            this.formParams = new HashMap<String, Object>();
        }
        this.formParams.put(name, new FileItem(originalFilename, inputStream, mimeType, size));
        if (this.contentType == null) {
            this.contentType = "multipart/form-data;charset=utf-8";
        }
        if (!this.multipart) {
            this.multipart = true;
            this.boundary = String.valueOf(System.nanoTime());
            this.contentType = this.contentType + ";boundary=" + this.boundary;
        }
        return this;
    }

    public HttpRequestEntity fileParam(String name, String originalFilename, byte[] data, String mimeType) {
        if (this.formParams == null) {
            this.formParams = new HashMap<String, Object>();
        }
        this.formParams.put(name, new FileItem(originalFilename, data, mimeType));
        if (this.contentType == null) {
            this.contentType = "multipart/form-data;charset=utf-8";
        }
        if (!this.multipart) {
            this.multipart = true;
            this.boundary = String.valueOf(System.nanoTime());
            this.contentType = this.contentType + ";boundary=" + this.boundary;
        }
        return this;
    }

    public HttpRequestEntity formParams(Object formdata) {
        this.formParams = formdata instanceof Map ? (Map<Object, Object>)formdata : BeanUtils.beanToMap(formdata);
        return this;
    }

    public HttpRequestEntity formParam(String name, String value) {
        if (this.formParams == null) {
            this.formParams = new HashMap<String, Object>();
        }
        this.formParams.put(name, value);
        if (this.contentType == null) {
            this.contentType = "application/x-www-form-urlencoded; charset=utf-8";
        }
        return this;
    }

    public String getBody() {
        if (this.body == null && HttpMethod.POST.equals((Object)this.method) && this.getContentType().startsWith("application/json; charset=")) {
            this.body = "{}";
        }
        return this.body;
    }

    public HttpRequestEntity body(String body) {
        if (this.method != HttpMethod.POST || body == null) {
            return null;
        }
        this.body = body.toString();
        return this;
    }

    public HttpRequestEntity objectBody(Object body) {
        if (this.method != HttpMethod.POST || body == null) {
            return null;
        }
        this.body = body instanceof String ? body.toString() : JsonUtils.toJson(body);
        return this;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public BasicAuthParams getBasicAuth() {
        return this.basicAuth;
    }

    public HttpRequestEntity basicAuth(String userName, String password) {
        this.basicAuth = new BasicAuthParams(userName, password);
        return this;
    }

    public static String parseContentTypeCharset(String contentType) {
        String[] params;
        String charset = "utf-8";
        if (StringUtils.isBlank((CharSequence)contentType)) {
            return charset;
        }
        for (String param : params = StringUtils.split((String)contentType, (String)";")) {
            if (!(param = param.trim()).toLowerCase().startsWith("charset")) continue;
            String[] pair = param.split("=", 2);
            if (pair.length != 2 || StringUtils.isEmpty((CharSequence)pair[1])) break;
            charset = pair[1].trim();
            break;
        }
        return charset;
    }

    public StringBuilder buildRequestLog() {
        if (!GlobalContext.isStarting() && !Thread.currentThread().getName().contains(HTTP_THREAD_NAME)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\n---------------backend request trace start--------------------");
        builder.append("\nurl:").append(this.uri);
        if (this.headers != null) {
            builder.append("\nheaders");
            for (String header : this.headers.keySet()) {
                builder.append("\n - ").append(header).append(":").append(this.headers.get(header));
            }
        }
        if (this.getQueryParams() != null && !this.getQueryParams().isEmpty()) {
            builder.append("\nqueryParams:").append(this.getQueryParams());
        }
        if (this.getBody() != null) {
            if (this.body.length() > 500) {
                builder.append("\nbody:").append(this.body.substring(0, 500) + "...");
            } else {
                builder.append("\nbody:").append(this.body);
            }
        }
        return builder;
    }

    public HttpResponseEntity execute() {
        return HttpUtils.execute(this);
    }

    public void unset() {
        if (!this.isMultipart()) {
            return;
        }
        for (Map.Entry<String, Object> entry : this.formParams.entrySet()) {
            Object entryValue = entry.getValue();
            if (entryValue == null || !(entryValue instanceof FileItem)) continue;
            FileItem fileItem = (FileItem)entryValue;
            if (fileItem.content != null) {
                FileItem.access$002(fileItem, null);
                continue;
            }
            if (!fileItem.createdTempFile) continue;
            try {
                FileUtils.forceDelete((File)fileItem.file);
                fileItem.createdTempFile = false;
            }
            catch (Exception exception) {}
        }
    }

    public static class FileItem {
        private static int chunkSizeLimit = ResourceUtils.getInt("mendmix-cloud.httputil.fileupload.chunkSizeLimit", 0x100000);
        private static String tmpDir = System.getProperty("java.io.tmpdir") + File.separator + "jeesuite";
        private String fileName;
        private String mimeType;
        private byte[] content;
        private File file;
        private InputStream inputStream;
        private long size;
        private int chunkNum = 1;
        private long offset;
        private boolean createdTempFile;

        public FileItem(File file) {
            this.file = file;
            this.setFileName(file.getName());
            this.setSize(file.length());
        }

        public FileItem(String filePath) {
            this(new File(filePath));
        }

        public FileItem(String fileName, byte[] content) {
            this.content = content;
            this.size = content.length;
            this.setFileName(fileName);
        }

        public FileItem(String fileName, byte[] content, String mimeType) {
            this(fileName, content);
            if (mimeType != null) {
                this.mimeType = mimeType;
            }
        }

        public FileItem(String originalFilename, InputStream inputStream, String mimeType, long size) {
            this.setFileName(originalFilename);
            if (mimeType != null) {
                this.mimeType = mimeType;
            }
            this.setSize(size);
            if (this.chunkNum > 1) {
                String ext = null;
                ext = originalFilename.contains(".") ? originalFilename.substring(originalFilename.lastIndexOf(".")) : "." + (String)StringUtils.defaultIfBlank((CharSequence)MimeTypeUtils.getFileExtension(mimeType), (CharSequence)"tmp");
                this.file = new File(tmpDir, UUID.randomUUID().toString() + ext);
                FileOutputStream outputStream = null;
                try {
                    outputStream = new FileOutputStream(this.file);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                    this.createdTempFile = true;
                }
                catch (Exception e) {
                    throw new MendmixBaseException("\u5199\u5165\u4e34\u65f6\u6587\u4ef6\u9519\u8bef:" + e.getMessage());
                }
                finally {
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            this.inputStream = inputStream;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getMimeType() throws IOException {
            MimeTypeUtils.FileMeta fileMeta;
            if (this.mimeType == null && (fileMeta = MimeTypeUtils.getFileMeta(this.getContent())) != null) {
                return fileMeta.getMimeType();
            }
            return this.mimeType;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public long getSize() {
            return this.size;
        }

        public int getChunkNum() {
            return this.chunkNum;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
            if (fileName.contains(".")) {
                String extension = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
                this.mimeType = MimeTypeUtils.getFileMimeType(extension);
            }
        }

        private void setSize(long size) {
            this.size = size;
            if (chunkSizeLimit > 0 && size > (long)chunkSizeLimit) {
                this.chunkNum = (int)(size / (long)chunkSizeLimit);
                if (size / (long)chunkSizeLimit > 0L) {
                    ++this.chunkNum;
                }
            }
        }

        public byte[] getContent() throws IOException {
            if (this.chunkNum > 1) {
                if (this.offset >= this.size) {
                    return new byte[0];
                }
                byte[] data = FileItem.getFileChunk(this.file, this.offset, chunkSizeLimit);
                this.offset += (long)chunkSizeLimit;
                if (this.offset > this.size) {
                    this.offset = this.size;
                }
                return data;
            }
            if (this.content != null) {
                return this.content;
            }
            if (this.inputStream == null && this.file != null && this.file.exists()) {
                this.inputStream = new FileInputStream(this.file);
            }
            if (this.inputStream == null) {
                return null;
            }
            ByteArrayOutputStream out = null;
            try {
                int ch;
                out = new ByteArrayOutputStream();
                while ((ch = this.inputStream.read()) != -1) {
                    out.write(ch);
                }
                this.content = out.toByteArray();
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (this.inputStream != null) {
                    this.inputStream.close();
                    this.inputStream = null;
                }
            }
            return this.content;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static byte[] getFileChunk(File file, long offset, int chunkSize) {
            block20: {
                byte[] byArray;
                byte[] result = new byte[chunkSize];
                RandomAccessFile accessFile = null;
                try {
                    accessFile = new RandomAccessFile(file, "r");
                    accessFile.seek(offset);
                    int readSize = accessFile.read(result);
                    if (readSize == -1) {
                        byte[] byArray2 = null;
                        return byArray2;
                    }
                    if (readSize == chunkSize) {
                        byte[] byArray3 = result;
                        return byArray3;
                    }
                    byte[] tmpByte = new byte[readSize];
                    System.arraycopy(result, 0, tmpByte, 0, readSize);
                    byArray = tmpByte;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break block20;
                }
                finally {
                    if (accessFile != null) {
                        try {
                            accessFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return byArray;
            }
            return null;
        }

        static /* synthetic */ byte[] access$002(FileItem x0, byte[] x1) {
            x0.content = x1;
            return x1;
        }

        static {
            File dir = new File(tmpDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }
    }

    public static class BasicAuthParams {
        private String name;
        private String password;

        public BasicAuthParams(String name, String password) {
            this.name = name;
            this.password = password;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getEncodeBasicAuth() {
            String encoded = Base64.encodeToString((this.name + ":" + this.password).getBytes(StandardCharsets.UTF_8), false);
            return "Basic " + encoded;
        }
    }
}

