/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.http;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.GlobalContext;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.model.Page;
import org.dromara.mendmix.common.util.ExceptionFormatUtils;
import org.dromara.mendmix.common.util.JsonUtils;

public class HttpResponseEntity {
    private static final String msgAlias = "message";
    public static final List<String> successCodes = Arrays.asList("200", "0000", "0");
    private int statusCode;
    private String body;
    @JsonIgnore
    private Map<String, String> headers;
    private String bizCode;
    private String message;
    @JsonIgnore
    private JsonNode bodyJsonObject;
    @JsonIgnore
    private Boolean successed;
    @JsonIgnore
    private Boolean isJson;

    public HttpResponseEntity() {
    }

    public HttpResponseEntity(int statusCode, String message) {
        this.statusCode = statusCode;
        this.message = message;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getBody() {
        return this.body;
    }

    public String getBizCode() {
        return this.bizCode;
    }

    public boolean isJson() {
        if (this.isJson == null) {
            this.isJson = this.body != null && JsonUtils.isJsonString(this.body);
        }
        return this.isJson;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
    }

    @JsonIgnore
    public JsonNode getBodyJsonObject() {
        if (this.bodyJsonObject == null) {
            this.handleBizException();
        }
        return this.bodyJsonObject;
    }

    @JsonIgnore
    public String getUnwrapBody() {
        if (!this.isSuccessed()) {
            MendmixBaseException e = new MendmixBaseException(this.getStatusCode(), this.getBizCode(), this.getMessage());
            throw (MendmixBaseException)ExceptionFormatUtils.wrapExtraExceptionMessages("httpUtils", e);
        }
        return this.body;
    }

    public Map<String, Object> toMap() {
        String json = this.getUnwrapBody();
        if (!this.isJson.booleanValue()) {
            return null;
        }
        return JsonUtils.toHashMap(json);
    }

    public <T> T toObject(Class<T> clazz) {
        String json = this.getUnwrapBody();
        if (!this.isJson.booleanValue()) {
            return null;
        }
        return JsonUtils.toObject(json, clazz);
    }

    public <T> List<T> toList(Class<T> clazz) {
        String json = this.getUnwrapBody();
        if (!this.isJson.booleanValue()) {
            return null;
        }
        return JsonUtils.toList(json, clazz);
    }

    public String toValue(String selectNode) {
        String value = JsonUtils.getJsonNodeValue(this.getUnwrapBody(), selectNode);
        return value;
    }

    public <T> T toObject(Class<T> clazz, String selectNode) {
        String unwrapBody = this.getUnwrapBody();
        if (!this.isJson.booleanValue()) {
            return null;
        }
        String json = JsonUtils.getJsonNodeValue(unwrapBody, selectNode);
        return JsonUtils.toObject(json, clazz);
    }

    public <T> List<T> toList(Class<T> clazz, String selectNode) {
        String unwrapBody = this.getUnwrapBody();
        if (!this.isJson.booleanValue()) {
            return null;
        }
        String json = JsonUtils.getJsonNodeValue(unwrapBody, selectNode);
        return JsonUtils.toList(json, clazz);
    }

    public <T> Page<T> toPage(Class<T> clazz) {
        String json = this.getUnwrapBody();
        JsonNode jsonNode = JsonUtils.getNode(json, null);
        Page<T> page = new Page<T>();
        page.setPageNo(jsonNode.get("pageNo").asInt());
        page.setPageSize(jsonNode.get("pageSize").asInt());
        page.setTotal(jsonNode.get("total").asLong());
        page.setData(JsonUtils.toList(jsonNode.get("data").toString(), clazz));
        return page;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public boolean isSuccessed() {
        this.handleBizException();
        return this.successed;
    }

    public String getMessage() {
        this.handleBizException();
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public MendmixBaseException buildException() {
        return new MendmixBaseException(this.getStatusCode(), this.getBizCode(), this.getMessage());
    }

    public void appendResponseLog(StringBuilder builder) {
        builder.append("\nresponse");
        builder.append("\n - statusCode:").append(this.statusCode);
        if (this.headers != null) {
            builder.append("\n - headers:").append(this.headers);
        }
        if (this.body != null && this.statusCode != 404 && (GlobalContext.isStarting() || CurrentRuntimeContext.isDebugMode())) {
            if (this.body.length() > 200) {
                builder.append("\n - body:").append(this.body.substring(0, 200) + "...");
            } else {
                builder.append("\n - body:").append(this.body);
            }
        }
        builder.append("\n---------------backend request trace end--------------------");
    }

    public boolean httpOk() {
        return this.statusCode == 200 || this.statusCode >= 200 && this.statusCode <= 210;
    }

    public HttpResponseEntity handleBizException() {
        if (this.successed != null) {
            return this;
        }
        this.successed = this.httpOk();
        if (this.successed.booleanValue() && this.isJson()) {
            this.bodyJsonObject = JsonUtils.toJsonNode(this.body);
            if (!this.bodyJsonObject.has("code")) {
                return this;
            }
            if (!(this.bodyJsonObject.size() <= 1 || this.bodyJsonObject.has("data") || this.bodyJsonObject.has("msg") || this.bodyJsonObject.has(msgAlias))) {
                return this;
            }
            String code = this.bodyJsonObject.get("code").asText();
            if (successCodes.contains(code)) {
                this.bodyJsonObject = this.bodyJsonObject.get("data");
                this.body = this.bodyJsonObject == null || this.bodyJsonObject instanceof NullNode ? null : this.bodyJsonObject.toString();
            } else {
                this.successed = false;
                String string = this.bizCode = this.bodyJsonObject.has("bizCode") ? this.bodyJsonObject.get("bizCode").textValue() : null;
                if (this.bodyJsonObject.has("msg")) {
                    this.message = this.bodyJsonObject.get("msg").textValue();
                } else if (this.bodyJsonObject.has(msgAlias)) {
                    this.message = this.bodyJsonObject.get(msgAlias).textValue();
                }
                int n = this.statusCode = StringUtils.isNumeric((CharSequence)code) ? Integer.parseInt(code) : 500;
            }
            if (!this.successed.booleanValue() && this.message == null) {
                this.message = "http\u8bf7\u6c42\u9519\u8bef[" + this.statusCode + "]";
            }
        } else if (!this.successed.booleanValue() && this.isJson()) {
            this.bodyJsonObject = JsonUtils.toJsonNode(this.body);
            if (!this.bodyJsonObject.has("error")) {
                return this;
            }
            this.message = this.bodyJsonObject.has("error_description") ? this.bodyJsonObject.get("error_description").textValue() : this.bodyJsonObject.get("error").textValue();
        }
        return this;
    }

    public String toString() {
        return "[statusCode=" + this.statusCode + ", body=" + this.body + ", message=" + this.message + "]";
    }
}

