/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.http.HttpClientProvider;
import org.dromara.mendmix.common.http.HttpMethod;
import org.dromara.mendmix.common.http.HttpRequestEntity;
import org.dromara.mendmix.common.http.HttpResponseEntity;
import org.dromara.mendmix.common.http.SSLHelper;

public class JdkHttpClient
implements HttpClientProvider {
    public static final String CHARSET_UTF8 = "utf-8";
    public static final String CONTENT_ENCODING_GZIP = "gzip";
    private static final String CONTENT_TYPE_JSON_PREFIX = "application/json; charset=";
    private static final String CONTENT_TYPE_FROM_URLENCODED_PREFIX = "application/x-www-form-urlencoded; charset=";
    public static final String CONTENT_TYPE_JSON_UTF8 = "application/json; charset=utf-8";
    public static final String CONTENT_TYPE_FROM_URLENCODED_UTF8 = "application/x-www-form-urlencoded; charset=utf-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponseEntity execute(HttpRequestEntity requestEntity) throws IOException {
        HttpURLConnection connection = null;
        OutputStream out = null;
        String charset = requestEntity.getCharset();
        String queryParam = JdkHttpClient.buildQuery(requestEntity.getQueryParams(), charset);
        URL url = JdkHttpClient.buildQueryParamUrl(requestEntity.getUri(), queryParam);
        try {
            connection = JdkHttpClient.buildConnection(url, requestEntity);
            if (HttpMethod.POST == requestEntity.getMethod()) {
                if (requestEntity.getBody() != null) {
                    byte[] data = requestEntity.getBody().getBytes();
                    connection.setRequestProperty("Content-Length", String.valueOf(data.length));
                    out = connection.getOutputStream();
                    out.write(data);
                    out.flush();
                } else if (requestEntity.getFormParams() != null) {
                    if (requestEntity.isMultipart()) {
                        byte[] entryBoundaryBytes = ("\r\n--" + requestEntity.getBoundary() + "\r\n").getBytes(charset);
                        Set<Map.Entry<String, Object>> formEntries = requestEntity.getFormParams().entrySet();
                        out = connection.getOutputStream();
                        for (Map.Entry<String, Object> entry : formEntries) {
                            byte[] textBytes;
                            HttpRequestEntity.FileItem curFileItem;
                            Object entryValue = entry.getValue();
                            if (entryValue == null) continue;
                            if (entryValue instanceof HttpRequestEntity.FileItem) {
                                curFileItem = (HttpRequestEntity.FileItem)entryValue;
                                if (curFileItem.getSize() == 0L) continue;
                                textBytes = JdkHttpClient.getFileEntry(entry.getKey(), curFileItem.getFileName(), curFileItem.getMimeType(), charset);
                            } else {
                                curFileItem = null;
                                textBytes = JdkHttpClient.getTextEntry(entry.getKey(), entry.getValue().toString(), charset);
                            }
                            out.write(entryBoundaryBytes);
                            out.write(textBytes);
                            if (curFileItem == null) continue;
                            for (int i = 0; i < curFileItem.getChunkNum(); ++i) {
                                out.write(curFileItem.getContent());
                            }
                        }
                        byte[] endBoundaryBytes = ("\r\n--" + requestEntity.getBoundary() + "--\r\n").getBytes(charset);
                        out.write(endBoundaryBytes);
                    } else {
                        String query = JdkHttpClient.buildQuery(requestEntity.getFormParams(), charset);
                        byte[] data = new byte[]{};
                        if (query != null) {
                            data = query.getBytes(charset);
                        }
                        connection.setRequestProperty("Content-Length", String.valueOf(data.length));
                        out = connection.getOutputStream();
                        out.write(data);
                    }
                }
            }
            HttpResponseEntity httpResponseEntity = JdkHttpClient.getResponseAsResponseEntity(connection, requestEntity.getCharset());
            return httpResponseEntity;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                connection.disconnect();
            }
            requestEntity.unset();
        }
    }

    private static URL buildQueryParamUrl(String strUrl, String query) throws IOException {
        URL url = new URL(strUrl);
        if (StringUtils.isEmpty((CharSequence)query)) {
            return url;
        }
        strUrl = StringUtils.isEmpty((CharSequence)url.getQuery()) ? (strUrl.endsWith("?") ? strUrl + query : strUrl + "?" + query) : (strUrl.endsWith("&") ? strUrl + query : strUrl + "&" + query);
        return new URL(strUrl);
    }

    public static String buildQuery(Map<String, Object> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        if (charset == null) {
            charset = CHARSET_UTF8;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, Object>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, Object> entry : entries) {
            String value;
            String name = entry.getKey();
            if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{name, value = Objects.toString(entry.getValue(), null)})) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    private static HttpResponseEntity getResponseAsResponseEntity(HttpURLConnection conn, String charset) throws IOException {
        HttpResponseEntity responseEntity = new HttpResponseEntity();
        InputStream es = conn.getErrorStream();
        responseEntity.setStatusCode(conn.getResponseCode());
        if (es == null) {
            String contentEncoding = conn.getContentEncoding();
            if (CONTENT_ENCODING_GZIP.equalsIgnoreCase(contentEncoding)) {
                responseEntity.setBody(JdkHttpClient.getStreamAsString(new GZIPInputStream(conn.getInputStream()), charset));
            } else {
                responseEntity.setBody(JdkHttpClient.getStreamAsString(conn.getInputStream(), charset));
            }
        } else {
            String msg = JdkHttpClient.getStreamAsString(es, charset);
            if (StringUtils.isEmpty((CharSequence)msg)) {
                responseEntity.setBody(conn.getResponseCode() + ":" + conn.getResponseMessage());
            } else {
                responseEntity.setBody(msg);
            }
        }
        return responseEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static byte[] getTextEntry(String fieldName, String fieldValue, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\"\r\nContent-Type:text/plain\r\n\r\n");
        entry.append(fieldValue);
        return entry.toString().getBytes(charset);
    }

    private static byte[] getFileEntry(String fieldName, String fileName, String mimeType, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\";filename=\"");
        entry.append(fileName);
        entry.append("\"\r\nContent-Type:");
        entry.append(mimeType);
        entry.append("\r\n\r\n");
        return entry.toString().getBytes(charset);
    }

    private static HttpURLConnection buildConnection(URL url, HttpRequestEntity requestEntity) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(requestEntity.getMethod().name());
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "*/*");
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        String contentType = requestEntity.getContentType();
        if (contentType != null) {
            conn.setRequestProperty("Content-Type", requestEntity.getContentType());
        }
        conn.setConnectTimeout(connectTimeout);
        conn.setReadTimeout(readTimeout);
        if (requestEntity.getHeaders() != null) {
            for (Map.Entry<String, String> entry : requestEntity.getHeaders().entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (requestEntity.getBasicAuth() != null) {
            conn.setRequestProperty("Authorization", requestEntity.getBasicAuth().getEncodeBasicAuth());
        }
        return conn;
    }

    static {
        SSLHelper.ignoreSSLVerify();
    }
}

