/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.http;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.http.HttpClientProvider;
import org.dromara.mendmix.common.http.HttpMethod;
import org.dromara.mendmix.common.http.HttpRequestEntity;
import org.dromara.mendmix.common.http.HttpResponseEntity;

public class OkHttp3Client
implements HttpClientProvider {
    private static Map<String, MediaType> mediaTypeMappings = new HashMap<String, MediaType>();
    private static OkHttpClient httpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponseEntity execute(HttpRequestEntity requestEntity) throws IOException {
        try {
            HttpUrl.Builder urlBuilder = HttpUrl.parse((String)requestEntity.getUri()).newBuilder();
            if (requestEntity.getQueryParams() != null) {
                for (String string : requestEntity.getQueryParams().keySet()) {
                    urlBuilder.addQueryParameter(string, requestEntity.getQueryParams().get(string).toString());
                }
            }
            Headers.Builder headerBuilder = new Headers.Builder();
            if (requestEntity.getHeaders() != null) {
                for (String key : requestEntity.getHeaders().keySet()) {
                    headerBuilder.add(key, requestEntity.getHeaders().get(key).toString());
                }
            }
            if (requestEntity.getBasicAuth() != null) {
                headerBuilder.add("Authorization", requestEntity.getBasicAuth().getEncodeBasicAuth());
            }
            Request.Builder builder = new Request.Builder().headers(headerBuilder.build()).url(urlBuilder.build());
            if (HttpMethod.POST == requestEntity.getMethod()) {
                RequestBody body = null;
                if (requestEntity.getBody() != null) {
                    body = FormBody.create((MediaType)OkHttp3Client.contentType2MediaType(requestEntity.getContentType()), (String)requestEntity.getBody());
                } else if (requestEntity.getFormParams() != null) {
                    MultipartBody.Builder builder2;
                    Set<Map.Entry<String, Object>> formEntries = requestEntity.getFormParams().entrySet();
                    if (requestEntity.isMultipart()) {
                        builder2 = new MultipartBody.Builder();
                        for (Map.Entry<String, Object> entry : formEntries) {
                            Object entryValue = entry.getValue();
                            if (entryValue == null) continue;
                            if (entryValue instanceof HttpRequestEntity.FileItem) {
                                HttpRequestEntity.FileItem fileItem = (HttpRequestEntity.FileItem)entryValue;
                                MediaType contentType = null;
                                if (fileItem.getMimeType() != null) {
                                    contentType = MediaType.parse((String)fileItem.getMimeType());
                                }
                                RequestBody requestBody = RequestBody.create((MediaType)contentType, (byte[])fileItem.getContent());
                                builder2.addFormDataPart(entry.getKey(), fileItem.getFileName(), requestBody);
                                continue;
                            }
                            builder2.addFormDataPart(entry.getKey(), entryValue.toString());
                        }
                        body = builder2.build();
                    } else {
                        builder2 = new FormBody.Builder();
                        for (Map.Entry<String, Object> entry : formEntries) {
                            if (entry.getValue() == null) continue;
                            builder2.add(entry.getKey(), entry.getValue().toString());
                        }
                        body = builder2.build();
                    }
                }
                if (body != null) {
                    builder.post(body);
                }
            }
            HttpResponseEntity responseEntity = new HttpResponseEntity();
            Request request = builder.build();
            Response response = httpClient.newCall(request).execute();
            responseEntity.setStatusCode(response.code());
            if (response.body() != null) {
                responseEntity.setBody(response.body().string());
            }
            if (!response.isSuccessful()) {
                responseEntity.setMessage((String)StringUtils.defaultIfBlank((CharSequence)response.message(), (CharSequence)responseEntity.getBody()));
            }
            HttpResponseEntity httpResponseEntity = responseEntity;
            return httpResponseEntity;
        }
        finally {
            requestEntity.unset();
        }
    }

    private static MediaType contentType2MediaType(String contentType) {
        if (mediaTypeMappings.containsKey(contentType)) {
            return mediaTypeMappings.get(contentType);
        }
        return MediaType.parse((String)"application/x-www-form-urlencoded; charset=utf-8");
    }

    static {
        mediaTypeMappings.put("application/json; charset=utf-8", MediaType.parse((String)"application/json; charset=utf-8"));
        mediaTypeMappings.put("application/x-www-form-urlencoded; charset=utf-8", MediaType.parse((String)"application/x-www-form-urlencoded; charset=utf-8"));
        httpClient = new OkHttpClient.Builder().connectionPool(new ConnectionPool(1, 60L, TimeUnit.SECONDS)).connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).readTimeout((long)readTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)readTimeout, TimeUnit.MILLISECONDS).build();
    }
}

