/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.jdbc;

import com.alibaba.druid.pool.DruidDataSource;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.common.util.SimpleCryptUtils;

public class DataSourceGroups {
    private static Map<String, DataSource> groupDataSources = new HashMap<String, DataSource>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSource getDataSource(String group) {
        if (groupDataSources.containsKey(group)) {
            return groupDataSources.get(group);
        }
        if (!ResourceUtils.containsProperty(group + ".dataSource.url")) {
            throw new MendmixBaseException("\u672a\u627e\u5230[" + group + "]\u6570\u636e\u5e93\u914d\u7f6e");
        }
        Map<String, DataSource> map = groupDataSources;
        synchronized (map) {
            if (groupDataSources.containsKey(group)) {
                return groupDataSources.get(group);
            }
            DruidDataSource dataSource = new DruidDataSource();
            dataSource.setDriverClassName(ResourceUtils.getProperty(group + ".dataSource.driverClassName", "com.mysql.cj.jdbc.Driver"));
            dataSource.setUrl(ResourceUtils.getProperty(group + ".dataSource.url"));
            dataSource.setUsername(ResourceUtils.getAndValidateProperty(group + ".dataSource.username"));
            String password = ResourceUtils.getAndValidateProperty(group + ".dataSource.password");
            if (password.startsWith("{Cipher}")) {
                password = SimpleCryptUtils.decrypt(password.replace("{Cipher}", ""));
            }
            dataSource.setPassword(password);
            dataSource.setMaxActive(ResourceUtils.getInt(group + ".dataSource.maxActive", 2));
            dataSource.setMinIdle(1);
            dataSource.setDefaultAutoCommit(true);
            dataSource.setTestOnBorrow(true);
            try {
                dataSource.init();
            }
            catch (SQLException e) {
                dataSource.close();
                throw new RuntimeException(e);
            }
            groupDataSources.put(group, (DataSource)dataSource);
            return dataSource;
        }
    }

    public static void close() {
        Collection<DataSource> dataSources = groupDataSources.values();
        for (DataSource dataSource : dataSources) {
            try {
                ((DruidDataSource)dataSource).close();
            }
            catch (Exception exception) {}
        }
    }
}

