/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.json;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.common.util.ResourceUtils;

public class CompsiteDateFormat
extends DateFormat {
    private static final long serialVersionUID = 1L;
    private static CompsiteDateFormat instance = new CompsiteDateFormat();
    private static final String STD_DATATIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String STD_DATATIME_MS_FORMAT = "yyyy-MM-dd HH:mm:ss SSS";
    private static final String CUSTOM_DATATIME_FORMAT = ResourceUtils.getProperty("mendmix-cloud.jackson.dateFormatPattern");
    private static Pattern timeMillsSuffixPattern = Pattern.compile(".*\\s+[0-9]{3}");
    private static String[] searchList = new String[]{"T", "Z"};
    private static String[] replacementList = new String[]{" ", " "};

    private CompsiteDateFormat() {
        String timeZoneId = ResourceUtils.getAnyProperty("spring.jackson.time-zone", "spring.jackson.timeZone");
        if (timeZoneId != null) {
            this.setCalendar(Calendar.getInstance(TimeZone.getTimeZone(timeZoneId)));
        }
    }

    public static CompsiteDateFormat singleton() {
        return instance;
    }

    private SimpleDateFormat adaptSimpleDateFormat(String dateString) {
        if (StringUtils.isBlank((CharSequence)dateString)) {
            return new SimpleDateFormat(StringUtils.defaultString((String)CUSTOM_DATATIME_FORMAT, (String)STD_DATATIME_FORMAT));
        }
        if (timeMillsSuffixPattern.matcher(dateString).matches()) {
            return new SimpleDateFormat(STD_DATATIME_MS_FORMAT);
        }
        return new SimpleDateFormat(STD_DATATIME_FORMAT);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        SimpleDateFormat dateFormat = this.adaptSimpleDateFormat(null);
        return dateFormat.format(date, toAppendTo, fieldPosition);
    }

    @Override
    public Date parse(String source, ParsePosition pos) {
        source = StringUtils.replaceEach((String)source, (String[])searchList, (String[])replacementList).trim();
        SimpleDateFormat dateFormat = this.adaptSimpleDateFormat(source);
        return dateFormat.parse(source, pos);
    }

    @Override
    public Date parse(String source) throws ParseException {
        source = StringUtils.replaceEach((String)source, (String[])searchList, (String[])replacementList).trim();
        SimpleDateFormat dateFormat = this.adaptSimpleDateFormat(source);
        return dateFormat.parse(source);
    }

    public String adaptFormat(Date date) {
        return this.adaptSimpleDateFormat(null).format(date);
    }

    @Override
    public Object clone() {
        return instance;
    }
}

