/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.common.lock;

import org.dromara.mendmix.common.lock.LockCaller;
import org.dromara.mendmix.common.lock.redis.RedisDistributeLock;

public class DistributeLockTemplate {
    private static final int _DEFAULT_LOCK_HOLD_MILLS = 30;

    public static <T> T execute(String lockId, LockCaller<T> caller) {
        return DistributeLockTemplate.execute(lockId, caller, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(String lockId, LockCaller<T> caller, int timeout) {
        RedisDistributeLock dLock = new RedisDistributeLock(lockId, timeout / 1000);
        boolean getLock = false;
        try {
            if (dLock.tryLock()) {
                getLock = true;
                T t = caller.onHolder();
                return t;
            }
            T t = caller.onWait();
            return t;
        }
        finally {
            if (getLock) {
                dLock.unlock();
            }
        }
    }
}

